/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStackResourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStackResourcesResponse> {
    private final List<StackResourceSummary> stackResourceSummaries;
    private final String nextToken;

    private ListStackResourcesResponse(BuilderImpl builder) {
        this.stackResourceSummaries = builder.stackResourceSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackResourceSummary> stackResourceSummaries() {
        return this.stackResourceSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackResourceSummaries() == null ? 0 : this.stackResourceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResponse)) {
            return false;
        }
        ListStackResourcesResponse other = (ListStackResourcesResponse)((Object)obj);
        if (other.stackResourceSummaries() == null ^ this.stackResourceSummaries() == null) {
            return false;
        }
        if (other.stackResourceSummaries() != null && !other.stackResourceSummaries().equals(this.stackResourceSummaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackResourceSummaries() != null) {
            sb.append("StackResourceSummaries: ").append(this.stackResourceSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StackResourceSummary> stackResourceSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackResourcesResponse model) {
            this.setStackResourceSummaries(model.stackResourceSummaries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<StackResourceSummary> getStackResourceSummaries() {
            return this.stackResourceSummaries;
        }

        @Override
        public final Builder stackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
            this.stackResourceSummaries(Arrays.asList(stackResourceSummaries));
            return this;
        }

        public final void setStackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
            this.stackResourceSummaries = StackResourceSummariesCopier.copy(stackResourceSummaries);
        }

        @SafeVarargs
        public final void setStackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
            this.stackResourceSummaries(Arrays.asList(stackResourceSummaries));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListStackResourcesResponse build() {
            return new ListStackResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStackResourcesResponse> {
        public Builder stackResourceSummaries(Collection<StackResourceSummary> var1);

        public Builder stackResourceSummaries(StackResourceSummary ... var1);

        public Builder nextToken(String var1);
    }
}

