/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.Export;
import software.amazon.awssdk.services.cloudformation.model.ExportsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListExportsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListExportsResponse> {
    private final List<Export> exports;
    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    public List<Export> exports() {
        return this.exports;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.exports() == null ? 0 : this.exports().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse)((Object)obj);
        if (other.exports() == null ^ this.exports() == null) {
            return false;
        }
        if (other.exports() != null && !other.exports().equals(this.exports())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exports() != null) {
            sb.append("Exports: ").append(this.exports()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Export> exports;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            this.setExports(model.exports);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Export> getExports() {
            return this.exports;
        }

        @Override
        public final Builder exports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Export ... exports) {
            this.exports(Arrays.asList(exports));
            return this;
        }

        public final void setExports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
        }

        @SafeVarargs
        public final void setExports(Export ... exports) {
            this.exports(Arrays.asList(exports));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListExportsResponse> {
        public Builder exports(Collection<Export> var1);

        public Builder exports(Export ... var1);

        public Builder nextToken(String var1);
    }
}

