/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclarationsCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateSummaryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetTemplateSummaryResponse> {
    private final List<ParameterDeclaration> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> resourceTypes;
    private final String version;
    private final String metadata;
    private final List<String> declaredTransforms;

    private GetTemplateSummaryResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.resourceTypes = builder.resourceTypes;
        this.version = builder.version;
        this.metadata = builder.metadata;
        this.declaredTransforms = builder.declaredTransforms;
    }

    public List<ParameterDeclaration> parameters() {
        return this.parameters;
    }

    public String description() {
        return this.description;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String version() {
        return this.version;
    }

    public String metadata() {
        return this.metadata;
    }

    public List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.capabilities() == null ? 0 : this.capabilities().hashCode());
        hashCode = 31 * hashCode + (this.capabilitiesReason() == null ? 0 : this.capabilitiesReason().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.declaredTransforms() == null ? 0 : this.declaredTransforms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResponse)) {
            return false;
        }
        GetTemplateSummaryResponse other = (GetTemplateSummaryResponse)((Object)obj);
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.capabilitiesReason() == null ^ this.capabilitiesReason() == null) {
            return false;
        }
        if (other.capabilitiesReason() != null && !other.capabilitiesReason().equals(this.capabilitiesReason())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.declaredTransforms() == null ^ this.declaredTransforms() == null) {
            return false;
        }
        return other.declaredTransforms() == null || other.declaredTransforms().equals(this.declaredTransforms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.capabilities() != null) {
            sb.append("Capabilities: ").append(this.capabilities()).append(",");
        }
        if (this.capabilitiesReason() != null) {
            sb.append("CapabilitiesReason: ").append(this.capabilitiesReason()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.declaredTransforms() != null) {
            sb.append("DeclaredTransforms: ").append(this.declaredTransforms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ParameterDeclaration> parameters;
        private String description;
        private List<String> capabilities;
        private String capabilitiesReason;
        private List<String> resourceTypes;
        private String version;
        private String metadata;
        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryResponse model) {
            this.setParameters(model.parameters);
            this.setDescription(model.description);
            this.setCapabilities(model.capabilities);
            this.setCapabilitiesReason(model.capabilitiesReason);
            this.setResourceTypes(model.resourceTypes);
            this.setVersion(model.version);
            this.setMetadata(model.metadata);
            this.setDeclaredTransforms(model.declaredTransforms);
        }

        public final Collection<ParameterDeclaration> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterDeclaration ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(ParameterDeclaration ... parameters) {
            this.parameters(Arrays.asList(parameters));
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @SafeVarargs
        public final void setCapabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
        }

        @SafeVarargs
        public final void setCapabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @SafeVarargs
        public final void setResourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Collection<String> getDeclaredTransforms() {
            return this.declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @SafeVarargs
        public final void setDeclaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
        }

        public GetTemplateSummaryResponse build() {
            return new GetTemplateSummaryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetTemplateSummaryResponse> {
        public Builder parameters(Collection<ParameterDeclaration> var1);

        public Builder parameters(ParameterDeclaration ... var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilities(Capability ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder version(String var1);

        public Builder metadata(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);
    }
}

