/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;

public class ListStackSetOperationsRequestMarshaller
implements Marshaller<Request<ListStackSetOperationsRequest>, ListStackSetOperationsRequest> {
    public Request<ListStackSetOperationsRequest> marshall(ListStackSetOperationsRequest listStackSetOperationsRequest) {
        if (listStackSetOperationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listStackSetOperationsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListStackSetOperations");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStackSetOperationsRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)listStackSetOperationsRequest.stackSetName()));
        }
        if (listStackSetOperationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listStackSetOperationsRequest.nextToken()));
        }
        if (listStackSetOperationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)listStackSetOperationsRequest.maxResults()));
        }
        return request;
    }
}

