/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;

public class DescribeStacksRequestMarshaller
implements Marshaller<Request<DescribeStacksRequest>, DescribeStacksRequest> {
    public Request<DescribeStacksRequest> marshall(DescribeStacksRequest describeStacksRequest) {
        if (describeStacksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeStacksRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeStacksRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)describeStacksRequest.stackName()));
        }
        if (describeStacksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeStacksRequest.nextToken()));
        }
        return request;
    }
}

