/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackInstance
implements ToCopyableBuilder<Builder, StackInstance> {
    private final String stackSetId;
    private final String region;
    private final String account;
    private final String stackId;
    private final List<Parameter> parameterOverrides;
    private final String status;
    private final String statusReason;

    private StackInstance(BuilderImpl builder) {
        this.stackSetId = builder.stackSetId;
        this.region = builder.region;
        this.account = builder.account;
        this.stackId = builder.stackId;
        this.parameterOverrides = builder.parameterOverrides;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public String stackSetId() {
        return this.stackSetId;
    }

    public String region() {
        return this.region;
    }

    public String account() {
        return this.account;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<Parameter> parameterOverrides() {
        return this.parameterOverrides;
    }

    public StackInstanceStatus status() {
        return StackInstanceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstance)) {
            return false;
        }
        StackInstance other = (StackInstance)obj;
        return Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.account(), other.account()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public String toString() {
        return ToString.builder((String)"StackInstance").add("StackSetId", (Object)this.stackSetId()).add("Region", (Object)this.region()).add("Account", (Object)this.account()).add("StackId", (Object)this.stackId()).add("ParameterOverrides", this.parameterOverrides()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "ParameterOverrides": {
                return Optional.ofNullable(clazz.cast(this.parameterOverrides()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetId;
        private String region;
        private String account;
        private String stackId;
        private List<Parameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstance model) {
            this.stackSetId(model.stackSetId);
            this.region(model.region);
            this.account(model.account);
            this.stackId(model.stackId);
            this.parameterOverrides(model.parameterOverrides);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAccount() {
            return this.account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<Parameter.Builder> getParameterOverrides() {
            return this.parameterOverrides != null ? (Collection)this.parameterOverrides.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<Parameter> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Parameter ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<Parameter.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<Parameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copyFromBuilder(parameterOverrides);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackInstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public StackInstance build() {
            return new StackInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackInstance> {
        public Builder stackSetId(String var1);

        public Builder region(String var1);

        public Builder account(String var1);

        public Builder stackId(String var1);

        public Builder parameterOverrides(Collection<Parameter> var1);

        public Builder parameterOverrides(Parameter ... var1);

        public Builder parameterOverrides(Consumer<Parameter.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(StackInstanceStatus var1);

        public Builder statusReason(String var1);
    }
}

