/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;

public class SetStackPolicyRequestMarshaller
implements Marshaller<Request<SetStackPolicyRequest>, SetStackPolicyRequest> {
    public Request<SetStackPolicyRequest> marshall(SetStackPolicyRequest setStackPolicyRequest) {
        if (setStackPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setStackPolicyRequest, "CloudFormationClient");
        request.addParameter("Action", "SetStackPolicy");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (setStackPolicyRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)setStackPolicyRequest.stackName()));
        }
        if (setStackPolicyRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringConversion.fromString((String)setStackPolicyRequest.stackPolicyBody()));
        }
        if (setStackPolicyRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringConversion.fromString((String)setStackPolicyRequest.stackPolicyURL()));
        }
        return request;
    }
}

