/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;

public class CancelUpdateStackRequestMarshaller
implements Marshaller<Request<CancelUpdateStackRequest>, CancelUpdateStackRequest> {
    public Request<CancelUpdateStackRequest> marshall(CancelUpdateStackRequest cancelUpdateStackRequest) {
        if (cancelUpdateStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)cancelUpdateStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CancelUpdateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelUpdateStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)cancelUpdateStackRequest.stackName()));
        }
        if (cancelUpdateStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)cancelUpdateStackRequest.clientRequestToken()));
        }
        return request;
    }
}

