/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.StackResource;

public class StackResourceUnmarshaller
implements Unmarshaller<StackResource, StaxUnmarshallerContext> {
    private static final StackResourceUnmarshaller INSTANCE = new StackResourceUnmarshaller();

    public StackResource unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StackResource.Builder stackResource = StackResource.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StackName", targetDepth)) {
                    stackResource.stackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackId", targetDepth)) {
                    stackResource.stackId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    stackResource.logicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PhysicalResourceId", targetDepth)) {
                    stackResource.physicalResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    stackResource.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timestamp", targetDepth)) {
                    stackResource.timestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatus", targetDepth)) {
                    stackResource.resourceStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceStatusReason", targetDepth)) {
                    stackResource.resourceStatusReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                stackResource.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StackResource)stackResource.build();
    }

    public static StackResourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

