/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.RequiresRecreation;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceTargetDefinition
implements ToCopyableBuilder<Builder, ResourceTargetDefinition> {
    private final String attribute;
    private final String name;
    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    public ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public String name() {
        return this.name;
    }

    public RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(this.requiresRecreation);
    }

    public String requiresRecreationAsString() {
        return this.requiresRecreation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresRecreationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requiresRecreationAsString(), other.requiresRecreationAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResourceTargetDefinition").add("Attribute", (Object)this.attributeAsString()).add("Name", (Object)this.name()).add("RequiresRecreation", (Object)this.requiresRecreationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeAsString()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "RequiresRecreation": {
                return Optional.of(clazz.cast(this.requiresRecreationAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String name;
        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            this.attribute(model.attribute);
            this.name(model.name);
            this.requiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequiresRecreation() {
            return this.requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
            return this;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceTargetDefinition> {
        public Builder attribute(String var1);

        public Builder attribute(ResourceAttribute var1);

        public Builder name(String var1);

        public Builder requiresRecreation(String var1);

        public Builder requiresRecreation(RequiresRecreation var1);
    }
}

