/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        SdkInternalList tagsList;
        SdkInternalList resourceTypesList;
        SdkInternalList capabilitiesList;
        SdkInternalList notificationARNsList;
        SdkInternalList parametersList;
        if (createStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createStackRequest.stackName()));
        }
        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackRequest.templateBody()));
        }
        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackRequest.templateURL()));
        }
        if ((parametersList = (SdkInternalList)createStackRequest.parameters()).isEmpty() && !parametersList.isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!parametersList.isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;
            for (Object parametersListValue : parametersList) {
                if (((Parameter)parametersListValue).parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)((Parameter)parametersListValue).parameterKey()));
                }
                if (((Parameter)parametersListValue).parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)((Parameter)parametersListValue).parameterValue()));
                }
                if (((Parameter)parametersListValue).usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)((Parameter)parametersListValue).usePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean((Boolean)createStackRequest.disableRollback()));
        }
        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringUtils.fromInteger((Integer)createStackRequest.timeoutInMinutes()));
        }
        if ((notificationARNsList = (SdkInternalList)createStackRequest.notificationARNs()).isEmpty() && !notificationARNsList.isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!notificationARNsList.isEmpty() || !notificationARNsList.isAutoConstruct()) {
            int notificationARNsListIndex = 1;
            for (Object notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if ((capabilitiesList = (SdkInternalList)createStackRequest.capabilities()).isEmpty() && !capabilitiesList.isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!capabilitiesList.isEmpty() || !capabilitiesList.isAutoConstruct()) {
            int capabilitiesListIndex = 1;
            for (Object capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if ((resourceTypesList = (SdkInternalList)createStackRequest.resourceTypes()).isEmpty() && !resourceTypesList.isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!resourceTypesList.isEmpty() || !resourceTypesList.isAutoConstruct()) {
            int resourceTypesListIndex = 1;
            for (String resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createStackRequest.roleARN()));
        }
        if (createStackRequest.onFailure() != null) {
            request.addParameter("OnFailure", StringUtils.fromString((String)createStackRequest.onFailure()));
        }
        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)createStackRequest.stackPolicyBody()));
        }
        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)createStackRequest.stackPolicyURL()));
        }
        if ((tagsList = (SdkInternalList)createStackRequest.tags()).isEmpty() && !tagsList.isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)createStackRequest.clientRequestToken()));
        }
        return request;
    }
}

