/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSummary
implements ToCopyableBuilder<Builder, StackSummary> {
    private final String stackId;
    private final String stackName;
    private final String templateDescription;
    private final Date creationTime;
    private final Date lastUpdatedTime;
    private final Date deletionTime;
    private final String stackStatus;
    private final String stackStatusReason;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.templateDescription = builder.templateDescription;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateDescription() {
        return this.templateDescription;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public Date lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Date deletionTime() {
        return this.deletionTime;
    }

    public String stackStatus() {
        return this.stackStatus;
    }

    public String stackStatusReason() {
        return this.stackStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.templateDescription() == null ? 0 : this.templateDescription().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.deletionTime() == null ? 0 : this.deletionTime().hashCode());
        hashCode = 31 * hashCode + (this.stackStatus() == null ? 0 : this.stackStatus().hashCode());
        hashCode = 31 * hashCode + (this.stackStatusReason() == null ? 0 : this.stackStatusReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateDescription() == null ^ this.templateDescription() == null) {
            return false;
        }
        if (other.templateDescription() != null && !other.templateDescription().equals(this.templateDescription())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.deletionTime() == null ^ this.deletionTime() == null) {
            return false;
        }
        if (other.deletionTime() != null && !other.deletionTime().equals(this.deletionTime())) {
            return false;
        }
        if (other.stackStatus() == null ^ this.stackStatus() == null) {
            return false;
        }
        if (other.stackStatus() != null && !other.stackStatus().equals(this.stackStatus())) {
            return false;
        }
        if (other.stackStatusReason() == null ^ this.stackStatusReason() == null) {
            return false;
        }
        return other.stackStatusReason() == null || other.stackStatusReason().equals(this.stackStatusReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.templateDescription() != null) {
            sb.append("TemplateDescription: ").append(this.templateDescription()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (this.deletionTime() != null) {
            sb.append("DeletionTime: ").append(this.deletionTime()).append(",");
        }
        if (this.stackStatus() != null) {
            sb.append("StackStatus: ").append(this.stackStatus()).append(",");
        }
        if (this.stackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(this.stackStatusReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String templateDescription;
        private Date creationTime;
        private Date lastUpdatedTime;
        private Date deletionTime;
        private String stackStatus;
        private String stackStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            this.setStackId(model.stackId);
            this.setStackName(model.stackName);
            this.setTemplateDescription(model.templateDescription);
            this.setCreationTime(model.creationTime);
            this.setLastUpdatedTime(model.lastUpdatedTime);
            this.setDeletionTime(model.deletionTime);
            this.setStackStatus(model.stackStatus);
            this.setStackStatusReason(model.stackStatusReason);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final Date getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy((Date)lastUpdatedTime);
            return this;
        }

        public final void setLastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy((Date)lastUpdatedTime);
        }

        public final Date getDeletionTime() {
            return this.deletionTime;
        }

        @Override
        public final Builder deletionTime(Date deletionTime) {
            this.deletionTime = StandardMemberCopier.copy((Date)deletionTime);
            return this;
        }

        public final void setDeletionTime(Date deletionTime) {
            this.deletionTime = StandardMemberCopier.copy((Date)deletionTime);
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final void setStackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public StackSummary build() {
            return new StackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSummary> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder templateDescription(String var1);

        public Builder creationTime(Date var1);

        public Builder lastUpdatedTime(Date var1);

        public Builder deletionTime(Date var1);

        public Builder stackStatus(String var1);

        public Builder stackStatus(StackStatus var1);

        public Builder stackStatusReason(String var1);
    }
}

