/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;

public class ListFacetNamesIterable
implements SdkIterable<ListFacetNamesResponse> {
    private final CloudDirectoryClient client;
    private final ListFacetNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFacetNamesIterable(CloudDirectoryClient client, ListFacetNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacetNamesResponseFetcher();
    }

    public Iterator<ListFacetNamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListFacetNamesIterable resume(ListFacetNamesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFacetNamesIterable(this.client, (ListFacetNamesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFacetNamesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFacetNamesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFacetNamesResponseFetcher
    implements SyncPageFetcher<ListFacetNamesResponse> {
        private ListFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFacetNamesResponse nextPage(ListFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetNamesIterable.this.client.listFacetNames(ListFacetNamesIterable.this.firstRequest);
            }
            return ListFacetNamesIterable.this.client.listFacetNames((ListFacetNamesRequest)((Object)ListFacetNamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

