/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishSchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, PublishSchemaRequest> {
    private static final SdkField<String> DEVELOPMENT_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishSchemaRequest.getter(PublishSchemaRequest::developmentSchemaArn)).setter(PublishSchemaRequest.setter(Builder::developmentSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishSchemaRequest.getter(PublishSchemaRequest::version)).setter(PublishSchemaRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> MINOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishSchemaRequest.getter(PublishSchemaRequest::minorVersion)).setter(PublishSchemaRequest.setter(Builder::minorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinorVersion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PublishSchemaRequest.getter(PublishSchemaRequest::name)).setter(PublishSchemaRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVELOPMENT_SCHEMA_ARN_FIELD, VERSION_FIELD, MINOR_VERSION_FIELD, NAME_FIELD));
    private final String developmentSchemaArn;
    private final String version;
    private final String minorVersion;
    private final String name;

    private PublishSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.developmentSchemaArn = builder.developmentSchemaArn;
        this.version = builder.version;
        this.minorVersion = builder.minorVersion;
        this.name = builder.name;
    }

    public String developmentSchemaArn() {
        return this.developmentSchemaArn;
    }

    public String version() {
        return this.version;
    }

    public String minorVersion() {
        return this.minorVersion;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.developmentSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.minorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishSchemaRequest)) {
            return false;
        }
        PublishSchemaRequest other = (PublishSchemaRequest)((Object)obj);
        return Objects.equals(this.developmentSchemaArn(), other.developmentSchemaArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.minorVersion(), other.minorVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"PublishSchemaRequest").add("DevelopmentSchemaArn", (Object)this.developmentSchemaArn()).add("Version", (Object)this.version()).add("MinorVersion", (Object)this.minorVersion()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevelopmentSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.developmentSchemaArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "MinorVersion": {
                return Optional.ofNullable(clazz.cast(this.minorVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishSchemaRequest, T> g) {
        return obj -> g.apply((PublishSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String developmentSchemaArn;
        private String version;
        private String minorVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishSchemaRequest model) {
            super(model);
            this.developmentSchemaArn(model.developmentSchemaArn);
            this.version(model.version);
            this.minorVersion(model.minorVersion);
            this.name(model.name);
        }

        public final String getDevelopmentSchemaArn() {
            return this.developmentSchemaArn;
        }

        @Override
        public final Builder developmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
            return this;
        }

        public final void setDevelopmentSchemaArn(String developmentSchemaArn) {
            this.developmentSchemaArn = developmentSchemaArn;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getMinorVersion() {
            return this.minorVersion;
        }

        @Override
        public final Builder minorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
            return this;
        }

        public final void setMinorVersion(String minorVersion) {
            this.minorVersion = minorVersion;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishSchemaRequest build() {
            return new PublishSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishSchemaRequest> {
        public Builder developmentSchemaArn(String var1);

        public Builder version(String var1);

        public Builder minorVersion(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

