/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceRequest extends CloudControlRequest implements
        ToCopyableBuilder<CreateResourceRequest.Builder, CreateResourceRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(CreateResourceRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(CreateResourceRequest::typeVersionId))
            .setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateResourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateResourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(CreateResourceRequest::desiredState)).setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DESIRED_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String typeName;

    private final String typeVersionId;

    private final String roleArn;

    private final String clientToken;

    private final String desiredState;

    private CreateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.desiredState = builder.desiredState;
    }

    /**
     * <p>
     * The name of the resource type.
     * </p>
     * 
     * @return The name of the resource type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * For private resource types, the type version to use in this resource operation. If you do not specify a resource
     * version, CloudFormation uses the default version.
     * </p>
     * 
     * @return For private resource types, the type version to use in this resource operation. If you do not specify a
     *         resource version, CloudFormation uses the default version.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use when
     * performing this resource operation. The role specified must have the permissions required for this operation. The
     * necessary permissions for each event handler are defined in the
     * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     * section of the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type
     * definition schema</a>.
     * </p>
     * <p>
     * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services
     * user credentials.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to
     *         use when performing this resource operation. The role specified must have the permissions required for
     *         this operation. The necessary permissions for each event handler are defined in the
     *         <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     *         section of the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
     *         type definition schema</a>.</p>
     *         <p>
     *         If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
     *         Services user credentials.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     *         >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to
     * ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request
     * retries and new resource requests. You might retry a resource request to ensure that it was successfully
     * received.
     * </p>
     * <p>
     * A client token is valid for 36 hours once used. After that, a resource request with the same client token is
     * treated as a new request.
     * </p>
     * <p>
     * If you do not specify a client token, one is generated for inclusion in the request.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
     * >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
     * Guide</i>.
     * </p>
     * 
     * @return A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this
     *         token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish
     *         between request retries and new resource requests. You might retry a resource request to ensure that it
     *         was successfully received.</p>
     *         <p>
     *         A client token is valid for 36 hours once used. After that, a resource request with the same client token
     *         is treated as a new request.
     *         </p>
     *         <p>
     *         If you do not specify a client token, one is generated for inclusion in the request.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
     *         >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
     *         Guide</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Structured data format representing the desired state of the resource, consisting of that resource's properties
     * and their desired values.
     * </p>
     * <note>
     * <p>
     * Cloud Control API currently supports JSON as a structured data format.
     * </p>
     * </note>
     * <p>
     * Specify the desired state as one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A JSON blob
     * </p>
     * </li>
     * <li>
     * <p>
     * A local path containing the desired state in JSON data format
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate"
     * >Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * <p>
     * For more information about the properties of a specific resource, refer to the related topic for the resource in
     * the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
     * Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.
     * </p>
     * 
     * @return Structured data format representing the desired state of the resource, consisting of that resource's
     *         properties and their desired values.</p> <note>
     *         <p>
     *         Cloud Control API currently supports JSON as a structured data format.
     *         </p>
     *         </note>
     *         <p>
     *         Specify the desired state as one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A JSON blob
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A local path containing the desired state in JSON data format
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate"
     *         >Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         For more information about the properties of a specific resource, refer to the related topic for the
     *         resource in the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.
     */
    public final String desiredState() {
        return desiredState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(desiredState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceRequest)) {
            return false;
        }
        CreateResourceRequest other = (CreateResourceRequest) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(desiredState(), other.desiredState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceRequest").add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("RoleArn", roleArn()).add("ClientToken", clientToken())
                .add("DesiredState", desiredState() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DesiredState", DESIRED_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceRequest, T> g) {
        return obj -> g.apply((CreateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceRequest> {
        /**
         * <p>
         * The name of the resource type.
         * </p>
         * 
         * @param typeName
         *        The name of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * For private resource types, the type version to use in this resource operation. If you do not specify a
         * resource version, CloudFormation uses the default version.
         * </p>
         * 
         * @param typeVersionId
         *        For private resource types, the type version to use in this resource operation. If you do not specify
         *        a resource version, CloudFormation uses the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API to use
         * when performing this resource operation. The role specified must have the permissions required for this
         * operation. The necessary permissions for each event handler are defined in the
         * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         * section of the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
         * type definition schema</a>.
         * </p>
         * <p>
         * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         * Services user credentials.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role for Cloud Control API
         *        to use when performing this resource operation. The role specified must have the permissions required
         *        for this operation. The necessary permissions for each event handler are defined in the
         *        <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         *        section of the <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >resource type definition schema</a>.</p>
         *        <p>
         *        If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         *        Services user credentials.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         *        >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token
         * to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between
         * request retries and new resource requests. You might retry a resource request to ensure that it was
         * successfully received.
         * </p>
         * <p>
         * A client token is valid for 36 hours once used. After that, a resource request with the same client token is
         * treated as a new request.
         * </p>
         * <p>
         * If you do not specify a client token, one is generated for inclusion in the request.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
         * >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
         * Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier to ensure the idempotency of the resource request. As a best practice, specify
         *        this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately
         *        distinguish between request retries and new resource requests. You might retry a resource request to
         *        ensure that it was successfully received.</p>
         *        <p>
         *        A client token is valid for 36 hours once used. After that, a resource request with the same client
         *        token is treated as a new request.
         *        </p>
         *        <p>
         *        If you do not specify a client token, one is generated for inclusion in the request.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
         *        >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Structured data format representing the desired state of the resource, consisting of that resource's
         * properties and their desired values.
         * </p>
         * <note>
         * <p>
         * Cloud Control API currently supports JSON as a structured data format.
         * </p>
         * </note>
         * <p>
         * Specify the desired state as one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A JSON blob
         * </p>
         * </li>
         * <li>
         * <p>
         * A local path containing the desired state in JSON data format
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate"
         * >Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User
         * Guide</i>.
         * </p>
         * <p>
         * For more information about the properties of a specific resource, refer to the related topic for the resource
         * in the <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.
         * </p>
         * 
         * @param desiredState
         *        Structured data format representing the desired state of the resource, consisting of that resource's
         *        properties and their desired values.</p> <note>
         *        <p>
         *        Cloud Control API currently supports JSON as a structured data format.
         *        </p>
         *        </note>
         *        <p>
         *        Specify the desired state as one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A JSON blob
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A local path containing the desired state in JSON data format
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-create.html#resource-operations-create-desiredstate"
         *        >Composing the desired state of the resource</a> in the <i>Amazon Web Services Cloud Control API User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        For more information about the properties of a specific resource, refer to the related topic for the
         *        resource in the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >Resource and property types reference</a> in the <i>CloudFormation Users Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredState(String desiredState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudControlRequest.BuilderImpl implements Builder {
        private String typeName;

        private String typeVersionId;

        private String roleArn;

        private String clientToken;

        private String desiredState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceRequest model) {
            super(model);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            desiredState(model.desiredState);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
