/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloud9.model.Cloud9Response;
import software.amazon.awssdk.services.cloud9.model.EnvironmentMember;
import software.amazon.awssdk.services.cloud9.model.EnvironmentMembersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentMembershipsResponse
extends Cloud9Response
implements ToCopyableBuilder<Builder, DescribeEnvironmentMembershipsResponse> {
    private static final SdkField<List<EnvironmentMember>> MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberships").getter(DescribeEnvironmentMembershipsResponse.getter(DescribeEnvironmentMembershipsResponse::memberships)).setter(DescribeEnvironmentMembershipsResponse.setter(Builder::memberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeEnvironmentMembershipsResponse.getter(DescribeEnvironmentMembershipsResponse::nextToken)).setter(DescribeEnvironmentMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EnvironmentMember> memberships;
    private final String nextToken;

    private DescribeEnvironmentMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.memberships = builder.memberships;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMemberships() {
        return this.memberships != null && !(this.memberships instanceof SdkAutoConstructList);
    }

    public List<EnvironmentMember> memberships() {
        return this.memberships;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberships() ? this.memberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentMembershipsResponse)) {
            return false;
        }
        DescribeEnvironmentMembershipsResponse other = (DescribeEnvironmentMembershipsResponse)((Object)obj);
        return this.hasMemberships() == other.hasMemberships() && Objects.equals(this.memberships(), other.memberships()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentMembershipsResponse").add("Memberships", this.hasMemberships() ? this.memberships() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberships": {
                return Optional.ofNullable(clazz.cast(this.memberships()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentMembershipsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Cloud9Response.BuilderImpl
    implements Builder {
        private List<EnvironmentMember> memberships = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentMembershipsResponse model) {
            super(model);
            this.memberships(model.memberships);
            this.nextToken(model.nextToken);
        }

        public final Collection<EnvironmentMember.Builder> getMemberships() {
            if (this.memberships instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberships != null ? (Collection)this.memberships.stream().map(EnvironmentMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder memberships(Collection<EnvironmentMember> memberships) {
            this.memberships = EnvironmentMembersListCopier.copy(memberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberships(EnvironmentMember ... memberships) {
            this.memberships(Arrays.asList(memberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberships(Consumer<EnvironmentMember.Builder> ... memberships) {
            this.memberships(Stream.of(memberships).map(c -> (EnvironmentMember)((EnvironmentMember.Builder)EnvironmentMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMemberships(Collection<EnvironmentMember.BuilderImpl> memberships) {
            this.memberships = EnvironmentMembersListCopier.copyFromBuilder(memberships);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEnvironmentMembershipsResponse build() {
            return new DescribeEnvironmentMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Cloud9Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentMembershipsResponse> {
        public Builder memberships(Collection<EnvironmentMember> var1);

        public Builder memberships(EnvironmentMember ... var1);

        public Builder memberships(Consumer<EnvironmentMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

