/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS Cloud9 development environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Environment::ownerArn)).setter(setter(Builder::ownerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()).build();

    private static final SdkField<EnvironmentLifecycle> LIFECYCLE_FIELD = SdkField
            .<EnvironmentLifecycle> builder(MarshallingType.SDK_POJO).getter(getter(Environment::lifecycle))
            .setter(setter(Builder::lifecycle)).constructor(EnvironmentLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, ARN_FIELD, OWNER_ARN_FIELD, LIFECYCLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String type;

    private final String arn;

    private final String ownerArn;

    private final EnvironmentLifecycle lifecycle;

    private Environment(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.arn = builder.arn;
        this.ownerArn = builder.ownerArn;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description for the environment.
     * </p>
     * 
     * @return The description for the environment.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of environment. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ssh</code>: Your own server connects to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ssh</code>: Your own server connects to the environment.
     *         </p>
     *         </li>
     * @see EnvironmentType
     */
    public EnvironmentType type() {
        return EnvironmentType.fromValue(type);
    }

    /**
     * <p>
     * The type of environment. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ssh</code>: Your own server connects to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of environment. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ssh</code>: Your own server connects to the environment.
     *         </p>
     *         </li>
     * @see EnvironmentType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment owner.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment owner.
     */
    public String ownerArn() {
        return ownerArn;
    }

    /**
     * <p>
     * The state of the environment in its creation or deletion lifecycle.
     * </p>
     * 
     * @return The state of the environment in its creation or deletion lifecycle.
     */
    public EnvironmentLifecycle lifecycle() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerArn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(ownerArn(), other.ownerArn())
                && Objects.equals(lifecycle(), other.lifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Environment").add("Id", id()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("Arn", arn()).add("OwnerArn", ownerArn()).add("Lifecycle", lifecycle()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ownerArn":
            return Optional.ofNullable(clazz.cast(ownerArn()));
        case "lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param id
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the environment.
         * </p>
         * 
         * @param description
         *        The description for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of environment. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ssh</code>: Your own server connects to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ssh</code>: Your own server connects to the environment.
         *        </p>
         *        </li>
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of environment. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ssh</code>: Your own server connects to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of environment. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ec2</code>: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ssh</code>: Your own server connects to the environment.
         *        </p>
         *        </li>
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder type(EnvironmentType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment owner.
         * </p>
         * 
         * @param ownerArn
         *        The Amazon Resource Name (ARN) of the environment owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerArn(String ownerArn);

        /**
         * <p>
         * The state of the environment in its creation or deletion lifecycle.
         * </p>
         * 
         * @param lifecycle
         *        The state of the environment in its creation or deletion lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(EnvironmentLifecycle lifecycle);

        /**
         * <p>
         * The state of the environment in its creation or deletion lifecycle.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentLifecycle.Builder} avoiding the need
         * to create one manually via {@link EnvironmentLifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentLifecycle.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecycle(EnvironmentLifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link EnvironmentLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(EnvironmentLifecycle)
         */
        default Builder lifecycle(Consumer<EnvironmentLifecycle.Builder> lifecycle) {
            return lifecycle(EnvironmentLifecycle.builder().applyMutation(lifecycle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String type;

        private String arn;

        private String ownerArn;

        private EnvironmentLifecycle lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            id(model.id);
            name(model.name);
            description(model.description);
            type(model.type);
            arn(model.arn);
            ownerArn(model.ownerArn);
            lifecycle(model.lifecycle);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EnvironmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getOwnerArn() {
            return ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        public final EnvironmentLifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(EnvironmentLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(EnvironmentLifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
