/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloud9.model.Cloud9Response;
import software.amazon.awssdk.services.cloud9.model.Environment;
import software.amazon.awssdk.services.cloud9.model.EnvironmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentsResponse
extends Cloud9Response
implements ToCopyableBuilder<Builder, DescribeEnvironmentsResponse> {
    private final List<Environment> environments;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
    }

    public List<Environment> environments() {
        return this.environments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.environments(), other.environments());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEnvironmentsResponse").add("Environments", this.environments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environments": {
                return Optional.of(clazz.cast(this.environments()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Response.BuilderImpl
    implements Builder {
        private List<Environment> environments;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            this.environments(model.environments);
        }

        public final Collection<Environment.Builder> getEnvironments() {
            return this.environments != null ? (Collection)this.environments.stream().map(Environment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environments(Collection<Environment> environments) {
            this.environments = EnvironmentListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Environment ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final void setEnvironments(Collection<Environment.BuilderImpl> environments) {
            this.environments = EnvironmentListCopier.copyFromBuilder(environments);
        }

        @Override
        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends Cloud9Response.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        public Builder environments(Collection<Environment> var1);

        public Builder environments(Environment ... var1);
    }
}

