/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloud9.model.Permissions;
import software.amazon.awssdk.services.cloud9.transform.EnvironmentMemberMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentMember
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentMember> {
    private final String permissions;
    private final String userId;
    private final String userArn;
    private final String environmentId;
    private final Instant lastAccess;

    private EnvironmentMember(BuilderImpl builder) {
        this.permissions = builder.permissions;
        this.userId = builder.userId;
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.lastAccess = builder.lastAccess;
    }

    public Permissions permissions() {
        return Permissions.fromValue(this.permissions);
    }

    public String permissionsAsString() {
        return this.permissions;
    }

    public String userId() {
        return this.userId;
    }

    public String userArn() {
        return this.userArn;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public Instant lastAccess() {
        return this.lastAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccess());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentMember)) {
            return false;
        }
        EnvironmentMember other = (EnvironmentMember)obj;
        return Objects.equals(this.permissionsAsString(), other.permissionsAsString()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastAccess(), other.lastAccess());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentMember").add("Permissions", (Object)this.permissionsAsString()).add("UserId", (Object)this.userId()).add("UserArn", (Object)this.userArn()).add("EnvironmentId", (Object)this.environmentId()).add("LastAccess", (Object)this.lastAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsString()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "lastAccess": {
                return Optional.ofNullable(clazz.cast(this.lastAccess()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentMemberMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String permissions;
        private String userId;
        private String userArn;
        private String environmentId;
        private Instant lastAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentMember model) {
            this.permissions(model.permissions);
            this.userId(model.userId);
            this.userArn(model.userArn);
            this.environmentId(model.environmentId);
            this.lastAccess(model.lastAccess);
        }

        public final String getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions(permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Instant getLastAccess() {
            return this.lastAccess;
        }

        @Override
        public final Builder lastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public final void setLastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
        }

        public EnvironmentMember build() {
            return new EnvironmentMember(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentMember> {
        public Builder permissions(String var1);

        public Builder permissions(Permissions var1);

        public Builder userId(String var1);

        public Builder userArn(String var1);

        public Builder environmentId(String var1);

        public Builder lastAccess(Instant var1);
    }
}

