/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloud9.model.Cloud9Request;
import software.amazon.awssdk.services.cloud9.model.MemberPermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentMembershipRequest
extends Cloud9Request
implements ToCopyableBuilder<Builder, CreateEnvironmentMembershipRequest> {
    private final String environmentId;
    private final String userArn;
    private final String permissions;

    private CreateEnvironmentMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.userArn = builder.userArn;
        this.permissions = builder.permissions;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String userArn() {
        return this.userArn;
    }

    public MemberPermissions permissions() {
        return MemberPermissions.fromValue(this.permissions);
    }

    public String permissionsAsString() {
        return this.permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentMembershipRequest)) {
            return false;
        }
        CreateEnvironmentMembershipRequest other = (CreateEnvironmentMembershipRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.permissionsAsString(), other.permissionsAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateEnvironmentMembershipRequest").add("EnvironmentId", (Object)this.environmentId()).add("UserArn", (Object)this.userArn()).add("Permissions", (Object)this.permissionsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Cloud9Request.BuilderImpl
    implements Builder {
        private String environmentId;
        private String userArn;
        private String permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentMembershipRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.userArn(model.userArn);
            this.permissions(model.permissions);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(MemberPermissions permissions) {
            this.permissions(permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentMembershipRequest build() {
            return new CreateEnvironmentMembershipRequest(this);
        }
    }

    public static interface Builder
    extends Cloud9Request.Builder,
    CopyableBuilder<Builder, CreateEnvironmentMembershipRequest> {
        public Builder environmentId(String var1);

        public Builder userArn(String var1);

        public Builder permissions(String var1);

        public Builder permissions(MemberPermissions var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

