/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.BusinessCallingSettings;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.VoiceConnectorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGlobalSettingsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, GetGlobalSettingsResponse> {
    private static final SdkField<BusinessCallingSettings> BUSINESS_CALLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetGlobalSettingsResponse.getter(GetGlobalSettingsResponse::businessCalling)).setter(GetGlobalSettingsResponse.setter(Builder::businessCalling)).constructor(BusinessCallingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessCalling").build()}).build();
    private static final SdkField<VoiceConnectorSettings> VOICE_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetGlobalSettingsResponse.getter(GetGlobalSettingsResponse::voiceConnector)).setter(GetGlobalSettingsResponse.setter(Builder::voiceConnector)).constructor(VoiceConnectorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_CALLING_FIELD, VOICE_CONNECTOR_FIELD));
    private final BusinessCallingSettings businessCalling;
    private final VoiceConnectorSettings voiceConnector;

    private GetGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.businessCalling = builder.businessCalling;
        this.voiceConnector = builder.voiceConnector;
    }

    public BusinessCallingSettings businessCalling() {
        return this.businessCalling;
    }

    public VoiceConnectorSettings voiceConnector() {
        return this.voiceConnector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.businessCalling());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGlobalSettingsResponse)) {
            return false;
        }
        GetGlobalSettingsResponse other = (GetGlobalSettingsResponse)((Object)obj);
        return Objects.equals(this.businessCalling(), other.businessCalling()) && Objects.equals(this.voiceConnector(), other.voiceConnector());
    }

    public String toString() {
        return ToString.builder((String)"GetGlobalSettingsResponse").add("BusinessCalling", (Object)this.businessCalling()).add("VoiceConnector", (Object)this.voiceConnector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BusinessCalling": {
                return Optional.ofNullable(clazz.cast(this.businessCalling()));
            }
            case "VoiceConnector": {
                return Optional.ofNullable(clazz.cast(this.voiceConnector()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGlobalSettingsResponse, T> g) {
        return obj -> g.apply((GetGlobalSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private BusinessCallingSettings businessCalling;
        private VoiceConnectorSettings voiceConnector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGlobalSettingsResponse model) {
            super(model);
            this.businessCalling(model.businessCalling);
            this.voiceConnector(model.voiceConnector);
        }

        public final BusinessCallingSettings.Builder getBusinessCalling() {
            return this.businessCalling != null ? this.businessCalling.toBuilder() : null;
        }

        @Override
        public final Builder businessCalling(BusinessCallingSettings businessCalling) {
            this.businessCalling = businessCalling;
            return this;
        }

        public final void setBusinessCalling(BusinessCallingSettings.BuilderImpl businessCalling) {
            this.businessCalling = businessCalling != null ? businessCalling.build() : null;
        }

        public final VoiceConnectorSettings.Builder getVoiceConnector() {
            return this.voiceConnector != null ? this.voiceConnector.toBuilder() : null;
        }

        @Override
        public final Builder voiceConnector(VoiceConnectorSettings voiceConnector) {
            this.voiceConnector = voiceConnector;
            return this;
        }

        public final void setVoiceConnector(VoiceConnectorSettings.BuilderImpl voiceConnector) {
            this.voiceConnector = voiceConnector != null ? voiceConnector.build() : null;
        }

        @Override
        public GetGlobalSettingsResponse build() {
            return new GetGlobalSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGlobalSettingsResponse> {
        public Builder businessCalling(BusinessCallingSettings var1);

        default public Builder businessCalling(Consumer<BusinessCallingSettings.Builder> businessCalling) {
            return this.businessCalling((BusinessCallingSettings)((BusinessCallingSettings.Builder)BusinessCallingSettings.builder().applyMutation(businessCalling)).build());
        }

        public Builder voiceConnector(VoiceConnectorSettings var1);

        default public Builder voiceConnector(Consumer<VoiceConnectorSettings.Builder> voiceConnector) {
            return this.voiceConnector((VoiceConnectorSettings)((VoiceConnectorSettings.Builder)VoiceConnectorSettings.builder().applyMutation(voiceConnector)).build());
        }
    }
}

