/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.OriginationRoute;
import software.amazon.awssdk.services.chime.model.OriginationRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Origination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Origination> {
    private static final SdkField<List<OriginationRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Origination.getter(Origination::routes)).setter(Origination.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OriginationRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Origination.getter(Origination::disabled)).setter(Origination.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, DISABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<OriginationRoute> routes;
    private final Boolean disabled;

    private Origination(BuilderImpl builder) {
        this.routes = builder.routes;
        this.disabled = builder.disabled;
    }

    public List<OriginationRoute> routes() {
        return this.routes;
    }

    public Boolean disabled() {
        return this.disabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routes());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origination)) {
            return false;
        }
        Origination other = (Origination)obj;
        return Objects.equals(this.routes(), other.routes()) && Objects.equals(this.disabled(), other.disabled());
    }

    public String toString() {
        return ToString.builder((String)"Origination").add("Routes", this.routes()).add("Disabled", (Object)this.disabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Origination, T> g) {
        return obj -> g.apply((Origination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OriginationRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Origination model) {
            this.routes(model.routes);
            this.disabled(model.disabled);
        }

        public final Collection<OriginationRoute.Builder> getRoutes() {
            return this.routes != null ? (Collection)this.routes.stream().map(OriginationRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<OriginationRoute> routes) {
            this.routes = OriginationRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(OriginationRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<OriginationRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (OriginationRoute)((OriginationRoute.Builder)OriginationRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<OriginationRoute.BuilderImpl> routes) {
            this.routes = OriginationRouteListCopier.copyFromBuilder(routes);
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public Origination build() {
            return new Origination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Origination> {
        public Builder routes(Collection<OriginationRoute> var1);

        public Builder routes(OriginationRoute ... var1);

        public Builder routes(Consumer<OriginationRoute.Builder> ... var1);

        public Builder disabled(Boolean var1);
    }
}

