/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.UpdateUserRequestItem;
import software.amazon.awssdk.services.chime.model.UpdateUserRequestItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateUserRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, BatchUpdateUserRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchUpdateUserRequest.getter(BatchUpdateUserRequest::accountId)).setter(BatchUpdateUserRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<List<UpdateUserRequestItem>> UPDATE_USER_REQUEST_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchUpdateUserRequest.getter(BatchUpdateUserRequest::updateUserRequestItems)).setter(BatchUpdateUserRequest.setter(Builder::updateUserRequestItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateUserRequestItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateUserRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, UPDATE_USER_REQUEST_ITEMS_FIELD));
    private final String accountId;
    private final List<UpdateUserRequestItem> updateUserRequestItems;

    private BatchUpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.updateUserRequestItems = builder.updateUserRequestItems;
    }

    public String accountId() {
        return this.accountId;
    }

    public List<UpdateUserRequestItem> updateUserRequestItems() {
        return this.updateUserRequestItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateUserRequestItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateUserRequest)) {
            return false;
        }
        BatchUpdateUserRequest other = (BatchUpdateUserRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.updateUserRequestItems(), other.updateUserRequestItems());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdateUserRequest").add("AccountId", (Object)this.accountId()).add("UpdateUserRequestItems", this.updateUserRequestItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "UpdateUserRequestItems": {
                return Optional.ofNullable(clazz.cast(this.updateUserRequestItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateUserRequest, T> g) {
        return obj -> g.apply((BatchUpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private List<UpdateUserRequestItem> updateUserRequestItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateUserRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.updateUserRequestItems(model.updateUserRequestItems);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<UpdateUserRequestItem.Builder> getUpdateUserRequestItems() {
            return this.updateUserRequestItems != null ? (Collection)this.updateUserRequestItems.stream().map(UpdateUserRequestItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updateUserRequestItems(Collection<UpdateUserRequestItem> updateUserRequestItems) {
            this.updateUserRequestItems = UpdateUserRequestItemListCopier.copy(updateUserRequestItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateUserRequestItems(UpdateUserRequestItem ... updateUserRequestItems) {
            this.updateUserRequestItems(Arrays.asList(updateUserRequestItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateUserRequestItems(Consumer<UpdateUserRequestItem.Builder> ... updateUserRequestItems) {
            this.updateUserRequestItems(Stream.of(updateUserRequestItems).map(c -> (UpdateUserRequestItem)((UpdateUserRequestItem.Builder)UpdateUserRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateUserRequestItems(Collection<UpdateUserRequestItem.BuilderImpl> updateUserRequestItems) {
            this.updateUserRequestItems = UpdateUserRequestItemListCopier.copyFromBuilder(updateUserRequestItems);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateUserRequest build() {
            return new BatchUpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateUserRequest> {
        public Builder accountId(String var1);

        public Builder updateUserRequestItems(Collection<UpdateUserRequestItem> var1);

        public Builder updateUserRequestItems(UpdateUserRequestItem ... var1);

        public Builder updateUserRequestItems(Consumer<UpdateUserRequestItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

