/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chime.model.ListPhoneNumberOrdersResponse;

public class ListPhoneNumberOrdersPublisher
implements SdkPublisher<ListPhoneNumberOrdersResponse> {
    private final ChimeAsyncClient client;
    private final ListPhoneNumberOrdersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPhoneNumberOrdersPublisher(ChimeAsyncClient client, ListPhoneNumberOrdersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPhoneNumberOrdersPublisher(ChimeAsyncClient client, ListPhoneNumberOrdersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPhoneNumberOrdersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPhoneNumberOrdersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPhoneNumberOrdersResponseFetcher
    implements AsyncPageFetcher<ListPhoneNumberOrdersResponse> {
        private ListPhoneNumberOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumberOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPhoneNumberOrdersResponse> nextPage(ListPhoneNumberOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumberOrdersPublisher.this.client.listPhoneNumberOrders(ListPhoneNumberOrdersPublisher.this.firstRequest);
            }
            return ListPhoneNumberOrdersPublisher.this.client.listPhoneNumberOrders((ListPhoneNumberOrdersRequest)((Object)ListPhoneNumberOrdersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

