/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.PhoneNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePhoneNumberResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, UpdatePhoneNumberResponse> {
    private static final SdkField<PhoneNumber> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdatePhoneNumberResponse.getter(UpdatePhoneNumberResponse::phoneNumber)).setter(UpdatePhoneNumberResponse.setter(Builder::phoneNumber)).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD));
    private final PhoneNumber phoneNumber;

    private UpdatePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumber = builder.phoneNumber;
    }

    public PhoneNumber phoneNumber() {
        return this.phoneNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePhoneNumberResponse)) {
            return false;
        }
        UpdatePhoneNumberResponse other = (UpdatePhoneNumberResponse)((Object)obj);
        return Objects.equals(this.phoneNumber(), other.phoneNumber());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePhoneNumberResponse").add("PhoneNumber", (Object)this.phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePhoneNumberResponse, T> g) {
        return obj -> g.apply((UpdatePhoneNumberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private PhoneNumber phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePhoneNumberResponse model) {
            super(model);
            this.phoneNumber(model.phoneNumber);
        }

        public final PhoneNumber.Builder getPhoneNumber() {
            return this.phoneNumber != null ? this.phoneNumber.toBuilder() : null;
        }

        @Override
        public final Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(PhoneNumber.BuilderImpl phoneNumber) {
            this.phoneNumber = phoneNumber != null ? phoneNumber.build() : null;
        }

        @Override
        public UpdatePhoneNumberResponse build() {
            return new UpdatePhoneNumberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePhoneNumberResponse> {
        public Builder phoneNumber(PhoneNumber var1);

        default public Builder phoneNumber(Consumer<PhoneNumber.Builder> phoneNumber) {
            return this.phoneNumber((PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation(phoneNumber)).build());
        }
    }
}

