/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ConversationRetentionSettings;
import software.amazon.awssdk.services.chime.model.RoomRetentionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetentionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetentionSettings> {
    private static final SdkField<RoomRetentionSettings> ROOM_RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoomRetentionSettings").getter(RetentionSettings.getter(RetentionSettings::roomRetentionSettings)).setter(RetentionSettings.setter(Builder::roomRetentionSettings)).constructor(RoomRetentionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomRetentionSettings").build()}).build();
    private static final SdkField<ConversationRetentionSettings> CONVERSATION_RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConversationRetentionSettings").getter(RetentionSettings.getter(RetentionSettings::conversationRetentionSettings)).setter(RetentionSettings.setter(Builder::conversationRetentionSettings)).constructor(ConversationRetentionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationRetentionSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_RETENTION_SETTINGS_FIELD, CONVERSATION_RETENTION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetentionSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RoomRetentionSettings roomRetentionSettings;
    private final ConversationRetentionSettings conversationRetentionSettings;

    private RetentionSettings(BuilderImpl builder) {
        this.roomRetentionSettings = builder.roomRetentionSettings;
        this.conversationRetentionSettings = builder.conversationRetentionSettings;
    }

    public final RoomRetentionSettings roomRetentionSettings() {
        return this.roomRetentionSettings;
    }

    public final ConversationRetentionSettings conversationRetentionSettings() {
        return this.conversationRetentionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomRetentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationRetentionSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionSettings)) {
            return false;
        }
        RetentionSettings other = (RetentionSettings)obj;
        return Objects.equals(this.roomRetentionSettings(), other.roomRetentionSettings()) && Objects.equals(this.conversationRetentionSettings(), other.conversationRetentionSettings());
    }

    public final String toString() {
        return ToString.builder((String)"RetentionSettings").add("RoomRetentionSettings", (Object)this.roomRetentionSettings()).add("ConversationRetentionSettings", (Object)this.conversationRetentionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomRetentionSettings": {
                return Optional.ofNullable(clazz.cast(this.roomRetentionSettings()));
            }
            case "ConversationRetentionSettings": {
                return Optional.ofNullable(clazz.cast(this.conversationRetentionSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoomRetentionSettings", ROOM_RETENTION_SETTINGS_FIELD);
        map.put("ConversationRetentionSettings", CONVERSATION_RETENTION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetentionSettings, T> g) {
        return obj -> g.apply((RetentionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RoomRetentionSettings roomRetentionSettings;
        private ConversationRetentionSettings conversationRetentionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionSettings model) {
            this.roomRetentionSettings(model.roomRetentionSettings);
            this.conversationRetentionSettings(model.conversationRetentionSettings);
        }

        public final RoomRetentionSettings.Builder getRoomRetentionSettings() {
            return this.roomRetentionSettings != null ? this.roomRetentionSettings.toBuilder() : null;
        }

        public final void setRoomRetentionSettings(RoomRetentionSettings.BuilderImpl roomRetentionSettings) {
            this.roomRetentionSettings = roomRetentionSettings != null ? roomRetentionSettings.build() : null;
        }

        @Override
        public final Builder roomRetentionSettings(RoomRetentionSettings roomRetentionSettings) {
            this.roomRetentionSettings = roomRetentionSettings;
            return this;
        }

        public final ConversationRetentionSettings.Builder getConversationRetentionSettings() {
            return this.conversationRetentionSettings != null ? this.conversationRetentionSettings.toBuilder() : null;
        }

        public final void setConversationRetentionSettings(ConversationRetentionSettings.BuilderImpl conversationRetentionSettings) {
            this.conversationRetentionSettings = conversationRetentionSettings != null ? conversationRetentionSettings.build() : null;
        }

        @Override
        public final Builder conversationRetentionSettings(ConversationRetentionSettings conversationRetentionSettings) {
            this.conversationRetentionSettings = conversationRetentionSettings;
            return this;
        }

        public RetentionSettings build() {
            return new RetentionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetentionSettings> {
        public Builder roomRetentionSettings(RoomRetentionSettings var1);

        default public Builder roomRetentionSettings(Consumer<RoomRetentionSettings.Builder> roomRetentionSettings) {
            return this.roomRetentionSettings((RoomRetentionSettings)((RoomRetentionSettings.Builder)RoomRetentionSettings.builder().applyMutation(roomRetentionSettings)).build());
        }

        public Builder conversationRetentionSettings(ConversationRetentionSettings var1);

        default public Builder conversationRetentionSettings(Consumer<ConversationRetentionSettings.Builder> conversationRetentionSettings) {
            return this.conversationRetentionSettings((ConversationRetentionSettings)((ConversationRetentionSettings.Builder)ConversationRetentionSettings.builder().applyMutation(conversationRetentionSettings)).build());
        }
    }
}

