/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.PhoneNumberType;
import software.amazon.awssdk.services.chime.model.PhoneNumberTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberCountry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberCountry> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(PhoneNumberCountry.getter(PhoneNumberCountry::countryCode)).setter(PhoneNumberCountry.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_PHONE_NUMBER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedPhoneNumberTypes").getter(PhoneNumberCountry.getter(PhoneNumberCountry::supportedPhoneNumberTypesAsStrings)).setter(PhoneNumberCountry.setter(Builder::supportedPhoneNumberTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPhoneNumberTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD, SUPPORTED_PHONE_NUMBER_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PhoneNumberCountry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String countryCode;
    private final List<String> supportedPhoneNumberTypes;

    private PhoneNumberCountry(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.supportedPhoneNumberTypes = builder.supportedPhoneNumberTypes;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final List<PhoneNumberType> supportedPhoneNumberTypes() {
        return PhoneNumberTypeListCopier.copyStringToEnum(this.supportedPhoneNumberTypes);
    }

    public final boolean hasSupportedPhoneNumberTypes() {
        return this.supportedPhoneNumberTypes != null && !(this.supportedPhoneNumberTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedPhoneNumberTypesAsStrings() {
        return this.supportedPhoneNumberTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedPhoneNumberTypes() ? this.supportedPhoneNumberTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberCountry)) {
            return false;
        }
        PhoneNumberCountry other = (PhoneNumberCountry)obj;
        return Objects.equals(this.countryCode(), other.countryCode()) && this.hasSupportedPhoneNumberTypes() == other.hasSupportedPhoneNumberTypes() && Objects.equals(this.supportedPhoneNumberTypesAsStrings(), other.supportedPhoneNumberTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberCountry").add("CountryCode", (Object)this.countryCode()).add("SupportedPhoneNumberTypes", this.hasSupportedPhoneNumberTypes() ? this.supportedPhoneNumberTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "SupportedPhoneNumberTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedPhoneNumberTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("SupportedPhoneNumberTypes", SUPPORTED_PHONE_NUMBER_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberCountry, T> g) {
        return obj -> g.apply((PhoneNumberCountry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String countryCode;
        private List<String> supportedPhoneNumberTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberCountry model) {
            this.countryCode(model.countryCode);
            this.supportedPhoneNumberTypesWithStrings(model.supportedPhoneNumberTypes);
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final Collection<String> getSupportedPhoneNumberTypes() {
            if (this.supportedPhoneNumberTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedPhoneNumberTypes;
        }

        public final void setSupportedPhoneNumberTypes(Collection<String> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copy(supportedPhoneNumberTypes);
        }

        @Override
        public final Builder supportedPhoneNumberTypesWithStrings(Collection<String> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copy(supportedPhoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPhoneNumberTypesWithStrings(String ... supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypesWithStrings(Arrays.asList(supportedPhoneNumberTypes));
            return this;
        }

        @Override
        public final Builder supportedPhoneNumberTypes(Collection<PhoneNumberType> supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes = PhoneNumberTypeListCopier.copyEnumToString(supportedPhoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPhoneNumberTypes(PhoneNumberType ... supportedPhoneNumberTypes) {
            this.supportedPhoneNumberTypes(Arrays.asList(supportedPhoneNumberTypes));
            return this;
        }

        public PhoneNumberCountry build() {
            return new PhoneNumberCountry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberCountry> {
        public Builder countryCode(String var1);

        public Builder supportedPhoneNumberTypesWithStrings(Collection<String> var1);

        public Builder supportedPhoneNumberTypesWithStrings(String ... var1);

        public Builder supportedPhoneNumberTypes(Collection<PhoneNumberType> var1);

        public Builder supportedPhoneNumberTypes(PhoneNumberType ... var1);
    }
}

