/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsConfigurationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutEventsConfigurationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutEventsConfigurationRequest.getter(PutEventsConfigurationRequest::accountId)).setter(PutEventsConfigurationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BotId").getter(PutEventsConfigurationRequest.getter(PutEventsConfigurationRequest::botId)).setter(PutEventsConfigurationRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutboundEventsHTTPSEndpoint").getter(PutEventsConfigurationRequest.getter(PutEventsConfigurationRequest::outboundEventsHTTPSEndpoint)).setter(PutEventsConfigurationRequest.setter(Builder::outboundEventsHTTPSEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEventsHTTPSEndpoint").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaFunctionArn").getter(PutEventsConfigurationRequest.getter(PutEventsConfigurationRequest::lambdaFunctionArn)).setter(PutEventsConfigurationRequest.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BOT_ID_FIELD, OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD, LAMBDA_FUNCTION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEventsConfigurationRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String botId;
    private final String outboundEventsHTTPSEndpoint;
    private final String lambdaFunctionArn;

    private PutEventsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.botId = builder.botId;
        this.outboundEventsHTTPSEndpoint = builder.outboundEventsHTTPSEndpoint;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String botId() {
        return this.botId;
    }

    public final String outboundEventsHTTPSEndpoint() {
        return this.outboundEventsHTTPSEndpoint;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundEventsHTTPSEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsConfigurationRequest)) {
            return false;
        }
        PutEventsConfigurationRequest other = (PutEventsConfigurationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.botId(), other.botId()) && Objects.equals(this.outboundEventsHTTPSEndpoint(), other.outboundEventsHTTPSEndpoint()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventsConfigurationRequest").add("AccountId", (Object)this.accountId()).add("BotId", (Object)this.botId()).add("OutboundEventsHTTPSEndpoint", (Object)(this.outboundEventsHTTPSEndpoint() == null ? null : "*** Sensitive Data Redacted ***")).add("LambdaFunctionArn", (Object)(this.lambdaFunctionArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BotId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "OutboundEventsHTTPSEndpoint": {
                return Optional.ofNullable(clazz.cast(this.outboundEventsHTTPSEndpoint()));
            }
            case "LambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("OutboundEventsHTTPSEndpoint", OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD);
        map.put("LambdaFunctionArn", LAMBDA_FUNCTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventsConfigurationRequest, T> g) {
        return obj -> g.apply((PutEventsConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String botId;
        private String outboundEventsHTTPSEndpoint;
        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsConfigurationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.botId(model.botId);
            this.outboundEventsHTTPSEndpoint(model.outboundEventsHTTPSEndpoint);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getOutboundEventsHTTPSEndpoint() {
            return this.outboundEventsHTTPSEndpoint;
        }

        public final void setOutboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
        }

        @Override
        public final Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsConfigurationRequest build() {
            return new PutEventsConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventsConfigurationRequest> {
        public Builder accountId(String var1);

        public Builder botId(String var1);

        public Builder outboundEventsHTTPSEndpoint(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

