/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelBanResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, CreateChannelBanResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(CreateChannelBanResponse.getter(CreateChannelBanResponse::channelArn)).setter(CreateChannelBanResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<Identity> MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Member").getter(CreateChannelBanResponse.getter(CreateChannelBanResponse::member)).setter(CreateChannelBanResponse.setter(Builder::member)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MEMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChannelBanResponse.memberNameToFieldInitializer();
    private final String channelArn;
    private final Identity member;

    private CreateChannelBanResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.member = builder.member;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final Identity member() {
        return this.member;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.member());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelBanResponse)) {
            return false;
        }
        CreateChannelBanResponse other = (CreateChannelBanResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.member(), other.member());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelBanResponse").add("ChannelArn", (Object)this.channelArn()).add("Member", (Object)this.member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Member": {
                return Optional.ofNullable(clazz.cast(this.member()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelArn", CHANNEL_ARN_FIELD);
        map.put("Member", MEMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelBanResponse, T> g) {
        return obj -> g.apply((CreateChannelBanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private Identity member;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelBanResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.member(model.member);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Identity.Builder getMember() {
            return this.member != null ? this.member.toBuilder() : null;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        @Override
        public CreateChannelBanResponse build() {
            return new CreateChannelBanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelBanResponse> {
        public Builder channelArn(String var1);

        public Builder member(Identity var1);

        default public Builder member(Consumer<Identity.Builder> member) {
            return this.member((Identity)((Identity.Builder)Identity.builder().applyMutation(member)).build());
        }
    }
}

