/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AccountStatus;
import software.amazon.awssdk.services.chime.model.AccountType;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.services.chime.model.LicenseListCopier;
import software.amazon.awssdk.services.chime.model.SigninDelegateGroup;
import software.amazon.awssdk.services.chime.model.SigninDelegateGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Account
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Account> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(Account.getter(Account::awsAccountId)).setter(Account.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Account.getter(Account::accountId)).setter(Account.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Account.getter(Account::name)).setter(Account.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ACCOUNT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountType").getter(Account.getter(Account::accountTypeAsString)).setter(Account.setter(Builder::accountType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountType").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(Account.getter(Account::createdTimestamp)).setter(Account.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEFAULT_LICENSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultLicense").getter(Account.getter(Account::defaultLicenseAsString)).setter(Account.setter(Builder::defaultLicense)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLicense").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedLicenses").getter(Account.getter(Account::supportedLicensesAsStrings)).setter(Account.setter(Builder::supportedLicensesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedLicenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountStatus").getter(Account.getter(Account::accountStatusAsString)).setter(Account.setter(Builder::accountStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountStatus").build()}).build();
    private static final SdkField<List<SigninDelegateGroup>> SIGNIN_DELEGATE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SigninDelegateGroups").getter(Account.getter(Account::signinDelegateGroups)).setter(Account.setter(Builder::signinDelegateGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigninDelegateGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SigninDelegateGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ACCOUNT_ID_FIELD, NAME_FIELD, ACCOUNT_TYPE_FIELD, CREATED_TIMESTAMP_FIELD, DEFAULT_LICENSE_FIELD, SUPPORTED_LICENSES_FIELD, ACCOUNT_STATUS_FIELD, SIGNIN_DELEGATE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Account.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String accountId;
    private final String name;
    private final String accountType;
    private final Instant createdTimestamp;
    private final String defaultLicense;
    private final List<String> supportedLicenses;
    private final String accountStatus;
    private final List<SigninDelegateGroup> signinDelegateGroups;

    private Account(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.accountType = builder.accountType;
        this.createdTimestamp = builder.createdTimestamp;
        this.defaultLicense = builder.defaultLicense;
        this.supportedLicenses = builder.supportedLicenses;
        this.accountStatus = builder.accountStatus;
        this.signinDelegateGroups = builder.signinDelegateGroups;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String name() {
        return this.name;
    }

    public final AccountType accountType() {
        return AccountType.fromValue(this.accountType);
    }

    public final String accountTypeAsString() {
        return this.accountType;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final License defaultLicense() {
        return License.fromValue(this.defaultLicense);
    }

    public final String defaultLicenseAsString() {
        return this.defaultLicense;
    }

    public final List<License> supportedLicenses() {
        return LicenseListCopier.copyStringToEnum(this.supportedLicenses);
    }

    public final boolean hasSupportedLicenses() {
        return this.supportedLicenses != null && !(this.supportedLicenses instanceof SdkAutoConstructList);
    }

    public final List<String> supportedLicensesAsStrings() {
        return this.supportedLicenses;
    }

    public final AccountStatus accountStatus() {
        return AccountStatus.fromValue(this.accountStatus);
    }

    public final String accountStatusAsString() {
        return this.accountStatus;
    }

    public final boolean hasSigninDelegateGroups() {
        return this.signinDelegateGroups != null && !(this.signinDelegateGroups instanceof SdkAutoConstructList);
    }

    public final List<SigninDelegateGroup> signinDelegateGroups() {
        return this.signinDelegateGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLicenseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedLicenses() ? this.supportedLicensesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigninDelegateGroups() ? this.signinDelegateGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.accountTypeAsString(), other.accountTypeAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.defaultLicenseAsString(), other.defaultLicenseAsString()) && this.hasSupportedLicenses() == other.hasSupportedLicenses() && Objects.equals(this.supportedLicensesAsStrings(), other.supportedLicensesAsStrings()) && Objects.equals(this.accountStatusAsString(), other.accountStatusAsString()) && this.hasSigninDelegateGroups() == other.hasSigninDelegateGroups() && Objects.equals(this.signinDelegateGroups(), other.signinDelegateGroups());
    }

    public final String toString() {
        return ToString.builder((String)"Account").add("AwsAccountId", (Object)this.awsAccountId()).add("AccountId", (Object)this.accountId()).add("Name", (Object)this.name()).add("AccountType", (Object)this.accountTypeAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("DefaultLicense", (Object)this.defaultLicenseAsString()).add("SupportedLicenses", this.hasSupportedLicenses() ? this.supportedLicensesAsStrings() : null).add("AccountStatus", (Object)this.accountStatusAsString()).add("SigninDelegateGroups", this.hasSigninDelegateGroups() ? this.signinDelegateGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AccountType": {
                return Optional.ofNullable(clazz.cast(this.accountTypeAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "DefaultLicense": {
                return Optional.ofNullable(clazz.cast(this.defaultLicenseAsString()));
            }
            case "SupportedLicenses": {
                return Optional.ofNullable(clazz.cast(this.supportedLicensesAsStrings()));
            }
            case "AccountStatus": {
                return Optional.ofNullable(clazz.cast(this.accountStatusAsString()));
            }
            case "SigninDelegateGroups": {
                return Optional.ofNullable(clazz.cast(this.signinDelegateGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AccountType", ACCOUNT_TYPE_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("DefaultLicense", DEFAULT_LICENSE_FIELD);
        map.put("SupportedLicenses", SUPPORTED_LICENSES_FIELD);
        map.put("AccountStatus", ACCOUNT_STATUS_FIELD);
        map.put("SigninDelegateGroups", SIGNIN_DELEGATE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Account, T> g) {
        return obj -> g.apply((Account)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String accountId;
        private String name;
        private String accountType;
        private Instant createdTimestamp;
        private String defaultLicense;
        private List<String> supportedLicenses = DefaultSdkAutoConstructList.getInstance();
        private String accountStatus;
        private List<SigninDelegateGroup> signinDelegateGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            this.awsAccountId(model.awsAccountId);
            this.accountId(model.accountId);
            this.name(model.name);
            this.accountType(model.accountType);
            this.createdTimestamp(model.createdTimestamp);
            this.defaultLicense(model.defaultLicense);
            this.supportedLicensesWithStrings(model.supportedLicenses);
            this.accountStatus(model.accountStatus);
            this.signinDelegateGroups(model.signinDelegateGroups);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccountType() {
            return this.accountType;
        }

        public final void setAccountType(String accountType) {
            this.accountType = accountType;
        }

        @Override
        public final Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Override
        public final Builder accountType(AccountType accountType) {
            this.accountType(accountType == null ? null : accountType.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getDefaultLicense() {
            return this.defaultLicense;
        }

        public final void setDefaultLicense(String defaultLicense) {
            this.defaultLicense = defaultLicense;
        }

        @Override
        public final Builder defaultLicense(String defaultLicense) {
            this.defaultLicense = defaultLicense;
            return this;
        }

        @Override
        public final Builder defaultLicense(License defaultLicense) {
            this.defaultLicense(defaultLicense == null ? null : defaultLicense.toString());
            return this;
        }

        public final Collection<String> getSupportedLicenses() {
            if (this.supportedLicenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedLicenses;
        }

        public final void setSupportedLicenses(Collection<String> supportedLicenses) {
            this.supportedLicenses = LicenseListCopier.copy(supportedLicenses);
        }

        @Override
        public final Builder supportedLicensesWithStrings(Collection<String> supportedLicenses) {
            this.supportedLicenses = LicenseListCopier.copy(supportedLicenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLicensesWithStrings(String ... supportedLicenses) {
            this.supportedLicensesWithStrings(Arrays.asList(supportedLicenses));
            return this;
        }

        @Override
        public final Builder supportedLicenses(Collection<License> supportedLicenses) {
            this.supportedLicenses = LicenseListCopier.copyEnumToString(supportedLicenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLicenses(License ... supportedLicenses) {
            this.supportedLicenses(Arrays.asList(supportedLicenses));
            return this;
        }

        public final String getAccountStatus() {
            return this.accountStatus;
        }

        public final void setAccountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
        }

        @Override
        public final Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        @Override
        public final Builder accountStatus(AccountStatus accountStatus) {
            this.accountStatus(accountStatus == null ? null : accountStatus.toString());
            return this;
        }

        public final List<SigninDelegateGroup.Builder> getSigninDelegateGroups() {
            List<SigninDelegateGroup.Builder> result = SigninDelegateGroupListCopier.copyToBuilder(this.signinDelegateGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSigninDelegateGroups(Collection<SigninDelegateGroup.BuilderImpl> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copyFromBuilder(signinDelegateGroups);
        }

        @Override
        public final Builder signinDelegateGroups(Collection<SigninDelegateGroup> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copy(signinDelegateGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(SigninDelegateGroup ... signinDelegateGroups) {
            this.signinDelegateGroups(Arrays.asList(signinDelegateGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder> ... signinDelegateGroups) {
            this.signinDelegateGroups(Stream.of(signinDelegateGroups).map(c -> (SigninDelegateGroup)((SigninDelegateGroup.Builder)SigninDelegateGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Account build() {
            return new Account(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Account> {
        public Builder awsAccountId(String var1);

        public Builder accountId(String var1);

        public Builder name(String var1);

        public Builder accountType(String var1);

        public Builder accountType(AccountType var1);

        public Builder createdTimestamp(Instant var1);

        public Builder defaultLicense(String var1);

        public Builder defaultLicense(License var1);

        public Builder supportedLicensesWithStrings(Collection<String> var1);

        public Builder supportedLicensesWithStrings(String ... var1);

        public Builder supportedLicenses(Collection<License> var1);

        public Builder supportedLicenses(License ... var1);

        public Builder accountStatus(String var1);

        public Builder accountStatus(AccountStatus var1);

        public Builder signinDelegateGroups(Collection<SigninDelegateGroup> var1);

        public Builder signinDelegateGroups(SigninDelegateGroup ... var1);

        public Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder> ... var1);
    }
}

