/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Proxy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Proxy> {
    private static final SdkField<Integer> DEFAULT_SESSION_EXPIRY_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultSessionExpiryMinutes").getter(Proxy.getter(Proxy::defaultSessionExpiryMinutes)).setter(Proxy.setter(Builder::defaultSessionExpiryMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSessionExpiryMinutes").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(Proxy.getter(Proxy::disabled)).setter(Proxy.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<String> FALL_BACK_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FallBackPhoneNumber").getter(Proxy.getter(Proxy::fallBackPhoneNumber)).setter(Proxy.setter(Builder::fallBackPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallBackPhoneNumber").build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberCountries").getter(Proxy.getter(Proxy::phoneNumberCountries)).setter(Proxy.setter(Builder::phoneNumberCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_SESSION_EXPIRY_MINUTES_FIELD, DISABLED_FIELD, FALL_BACK_PHONE_NUMBER_FIELD, PHONE_NUMBER_COUNTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Proxy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer defaultSessionExpiryMinutes;
    private final Boolean disabled;
    private final String fallBackPhoneNumber;
    private final List<String> phoneNumberCountries;

    private Proxy(BuilderImpl builder) {
        this.defaultSessionExpiryMinutes = builder.defaultSessionExpiryMinutes;
        this.disabled = builder.disabled;
        this.fallBackPhoneNumber = builder.fallBackPhoneNumber;
        this.phoneNumberCountries = builder.phoneNumberCountries;
    }

    public final Integer defaultSessionExpiryMinutes() {
        return this.defaultSessionExpiryMinutes;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final String fallBackPhoneNumber() {
        return this.fallBackPhoneNumber;
    }

    public final boolean hasPhoneNumberCountries() {
        return this.phoneNumberCountries != null && !(this.phoneNumberCountries instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberCountries() {
        return this.phoneNumberCountries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSessionExpiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallBackPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberCountries() ? this.phoneNumberCountries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Proxy)) {
            return false;
        }
        Proxy other = (Proxy)obj;
        return Objects.equals(this.defaultSessionExpiryMinutes(), other.defaultSessionExpiryMinutes()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.fallBackPhoneNumber(), other.fallBackPhoneNumber()) && this.hasPhoneNumberCountries() == other.hasPhoneNumberCountries() && Objects.equals(this.phoneNumberCountries(), other.phoneNumberCountries());
    }

    public final String toString() {
        return ToString.builder((String)"Proxy").add("DefaultSessionExpiryMinutes", (Object)this.defaultSessionExpiryMinutes()).add("Disabled", (Object)this.disabled()).add("FallBackPhoneNumber", (Object)(this.fallBackPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumberCountries", this.hasPhoneNumberCountries() ? this.phoneNumberCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultSessionExpiryMinutes": {
                return Optional.ofNullable(clazz.cast(this.defaultSessionExpiryMinutes()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "FallBackPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.fallBackPhoneNumber()));
            }
            case "PhoneNumberCountries": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultSessionExpiryMinutes", DEFAULT_SESSION_EXPIRY_MINUTES_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        map.put("FallBackPhoneNumber", FALL_BACK_PHONE_NUMBER_FIELD);
        map.put("PhoneNumberCountries", PHONE_NUMBER_COUNTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Proxy, T> g) {
        return obj -> g.apply((Proxy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer defaultSessionExpiryMinutes;
        private Boolean disabled;
        private String fallBackPhoneNumber;
        private List<String> phoneNumberCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Proxy model) {
            this.defaultSessionExpiryMinutes(model.defaultSessionExpiryMinutes);
            this.disabled(model.disabled);
            this.fallBackPhoneNumber(model.fallBackPhoneNumber);
            this.phoneNumberCountries(model.phoneNumberCountries);
        }

        public final Integer getDefaultSessionExpiryMinutes() {
            return this.defaultSessionExpiryMinutes;
        }

        public final void setDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
        }

        @Override
        public final Builder defaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
            this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getFallBackPhoneNumber() {
            return this.fallBackPhoneNumber;
        }

        public final void setFallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
        }

        @Override
        public final Builder fallBackPhoneNumber(String fallBackPhoneNumber) {
            this.fallBackPhoneNumber = fallBackPhoneNumber;
            return this;
        }

        public final Collection<String> getPhoneNumberCountries() {
            if (this.phoneNumberCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberCountries;
        }

        public final void setPhoneNumberCountries(Collection<String> phoneNumberCountries) {
            this.phoneNumberCountries = StringListCopier.copy(phoneNumberCountries);
        }

        @Override
        public final Builder phoneNumberCountries(Collection<String> phoneNumberCountries) {
            this.phoneNumberCountries = StringListCopier.copy(phoneNumberCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountries(String ... phoneNumberCountries) {
            this.phoneNumberCountries(Arrays.asList(phoneNumberCountries));
            return this;
        }

        public Proxy build() {
            return new Proxy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Proxy> {
        public Builder defaultSessionExpiryMinutes(Integer var1);

        public Builder disabled(Boolean var1);

        public Builder fallBackPhoneNumber(String var1);

        public Builder phoneNumberCountries(Collection<String> var1);

        public Builder phoneNumberCountries(String ... var1);
    }
}

