/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.PhoneNumberAssociationName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberAssociation> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(PhoneNumberAssociation.getter(PhoneNumberAssociation::value)).setter(PhoneNumberAssociation.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PhoneNumberAssociation.getter(PhoneNumberAssociation::nameAsString)).setter(PhoneNumberAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> ASSOCIATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AssociatedTimestamp").getter(PhoneNumberAssociation.getter(PhoneNumberAssociation::associatedTimestamp)).setter(PhoneNumberAssociation.setter(Builder::associatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, NAME_FIELD, ASSOCIATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Value", VALUE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("AssociatedTimestamp", ASSOCIATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String name;
    private final Instant associatedTimestamp;

    private PhoneNumberAssociation(BuilderImpl builder) {
        this.value = builder.value;
        this.name = builder.name;
        this.associatedTimestamp = builder.associatedTimestamp;
    }

    public final String value() {
        return this.value;
    }

    public final PhoneNumberAssociationName name() {
        return PhoneNumberAssociationName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Instant associatedTimestamp() {
        return this.associatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberAssociation)) {
            return false;
        }
        PhoneNumberAssociation other = (PhoneNumberAssociation)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.associatedTimestamp(), other.associatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberAssociation").add("Value", (Object)this.value()).add("Name", (Object)this.nameAsString()).add("AssociatedTimestamp", (Object)this.associatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "AssociatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.associatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberAssociation, T> g) {
        return obj -> g.apply((PhoneNumberAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String name;
        private Instant associatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberAssociation model) {
            this.value(model.value);
            this.name(model.name);
            this.associatedTimestamp(model.associatedTimestamp);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(PhoneNumberAssociationName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Instant getAssociatedTimestamp() {
            return this.associatedTimestamp;
        }

        public final void setAssociatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
        }

        @Override
        public final Builder associatedTimestamp(Instant associatedTimestamp) {
            this.associatedTimestamp = associatedTimestamp;
            return this;
        }

        public PhoneNumberAssociation build() {
            return new PhoneNumberAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberAssociation> {
        public Builder value(String var1);

        public Builder name(String var1);

        public Builder name(PhoneNumberAssociationName var1);

        public Builder associatedTimestamp(Instant var1);
    }
}

