/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppInstanceAdmin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppInstanceAdmin> {
    private static final SdkField<Identity> ADMIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Admin").getter(AppInstanceAdmin.getter(AppInstanceAdmin::admin)).setter(AppInstanceAdmin.setter(Builder::admin)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Admin").build()}).build();
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(AppInstanceAdmin.getter(AppInstanceAdmin::appInstanceArn)).setter(AppInstanceAdmin.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(AppInstanceAdmin.getter(AppInstanceAdmin::createdTimestamp)).setter(AppInstanceAdmin.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_FIELD, APP_INSTANCE_ARN_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Admin", ADMIN_FIELD);
            this.put("AppInstanceArn", APP_INSTANCE_ARN_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Identity admin;
    private final String appInstanceArn;
    private final Instant createdTimestamp;

    private AppInstanceAdmin(BuilderImpl builder) {
        this.admin = builder.admin;
        this.appInstanceArn = builder.appInstanceArn;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final Identity admin() {
        return this.admin;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.admin());
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceAdmin)) {
            return false;
        }
        AppInstanceAdmin other = (AppInstanceAdmin)obj;
        return Objects.equals(this.admin(), other.admin()) && Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"AppInstanceAdmin").add("Admin", (Object)this.admin()).add("AppInstanceArn", (Object)this.appInstanceArn()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Admin": {
                return Optional.ofNullable(clazz.cast(this.admin()));
            }
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceAdmin, T> g) {
        return obj -> g.apply((AppInstanceAdmin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identity admin;
        private String appInstanceArn;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceAdmin model) {
            this.admin(model.admin);
            this.appInstanceArn(model.appInstanceArn);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final Identity.Builder getAdmin() {
            return this.admin != null ? this.admin.toBuilder() : null;
        }

        public final void setAdmin(Identity.BuilderImpl admin) {
            this.admin = admin != null ? admin.build() : null;
        }

        @Override
        public final Builder admin(Identity admin) {
            this.admin = admin;
            return this;
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public AppInstanceAdmin build() {
            return new AppInstanceAdmin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppInstanceAdmin> {
        public Builder admin(Identity var1);

        default public Builder admin(Consumer<Identity.Builder> admin) {
            return this.admin((Identity)((Identity.Builder)Identity.builder().applyMutation(admin)).build());
        }

        public Builder appInstanceArn(String var1);

        public Builder createdTimestamp(Instant var1);
    }
}

