/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListAppInstanceUsersRequest;
import software.amazon.awssdk.services.chime.model.ListAppInstanceUsersResponse;

public class ListAppInstanceUsersPublisher
implements SdkPublisher<ListAppInstanceUsersResponse> {
    private final ChimeAsyncClient client;
    private final ListAppInstanceUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInstanceUsersPublisher(ChimeAsyncClient client, ListAppInstanceUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInstanceUsersPublisher(ChimeAsyncClient client, ListAppInstanceUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInstanceUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInstanceUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInstanceUsersResponseFetcher
    implements AsyncPageFetcher<ListAppInstanceUsersResponse> {
        private ListAppInstanceUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInstanceUsersResponse> nextPage(ListAppInstanceUsersResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceUsersPublisher.this.client.listAppInstanceUsers(ListAppInstanceUsersPublisher.this.firstRequest);
            }
            return ListAppInstanceUsersPublisher.this.client.listAppInstanceUsers((ListAppInstanceUsersRequest)((Object)ListAppInstanceUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

