/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMeetingDialOutRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateMeetingDialOutRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeetingId").getter(CreateMeetingDialOutRequest.getter(CreateMeetingDialOutRequest::meetingId)).setter(CreateMeetingDialOutRequest.setter(Builder::meetingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meetingId").build()}).build();
    private static final SdkField<String> FROM_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromPhoneNumber").getter(CreateMeetingDialOutRequest.getter(CreateMeetingDialOutRequest::fromPhoneNumber)).setter(CreateMeetingDialOutRequest.setter(Builder::fromPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPhoneNumber").build()}).build();
    private static final SdkField<String> TO_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToPhoneNumber").getter(CreateMeetingDialOutRequest.getter(CreateMeetingDialOutRequest::toPhoneNumber)).setter(CreateMeetingDialOutRequest.setter(Builder::toPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPhoneNumber").build()}).build();
    private static final SdkField<String> JOIN_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JoinToken").getter(CreateMeetingDialOutRequest.getter(CreateMeetingDialOutRequest::joinToken)).setter(CreateMeetingDialOutRequest.setter(Builder::joinToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD, FROM_PHONE_NUMBER_FIELD, TO_PHONE_NUMBER_FIELD, JOIN_TOKEN_FIELD));
    private final String meetingId;
    private final String fromPhoneNumber;
    private final String toPhoneNumber;
    private final String joinToken;

    private CreateMeetingDialOutRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.fromPhoneNumber = builder.fromPhoneNumber;
        this.toPhoneNumber = builder.toPhoneNumber;
        this.joinToken = builder.joinToken;
    }

    public final String meetingId() {
        return this.meetingId;
    }

    public final String fromPhoneNumber() {
        return this.fromPhoneNumber;
    }

    public final String toPhoneNumber() {
        return this.toPhoneNumber;
    }

    public final String joinToken() {
        return this.joinToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingDialOutRequest)) {
            return false;
        }
        CreateMeetingDialOutRequest other = (CreateMeetingDialOutRequest)((Object)obj);
        return Objects.equals(this.meetingId(), other.meetingId()) && Objects.equals(this.fromPhoneNumber(), other.fromPhoneNumber()) && Objects.equals(this.toPhoneNumber(), other.toPhoneNumber()) && Objects.equals(this.joinToken(), other.joinToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMeetingDialOutRequest").add("MeetingId", (Object)this.meetingId()).add("FromPhoneNumber", (Object)(this.fromPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("ToPhoneNumber", (Object)(this.toPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("JoinToken", (Object)(this.joinToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeetingId": {
                return Optional.ofNullable(clazz.cast(this.meetingId()));
            }
            case "FromPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.fromPhoneNumber()));
            }
            case "ToPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.toPhoneNumber()));
            }
            case "JoinToken": {
                return Optional.ofNullable(clazz.cast(this.joinToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingDialOutRequest, T> g) {
        return obj -> g.apply((CreateMeetingDialOutRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String meetingId;
        private String fromPhoneNumber;
        private String toPhoneNumber;
        private String joinToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingDialOutRequest model) {
            super(model);
            this.meetingId(model.meetingId);
            this.fromPhoneNumber(model.fromPhoneNumber);
            this.toPhoneNumber(model.toPhoneNumber);
            this.joinToken(model.joinToken);
        }

        public final String getMeetingId() {
            return this.meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getFromPhoneNumber() {
            return this.fromPhoneNumber;
        }

        public final void setFromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
        }

        @Override
        public final Builder fromPhoneNumber(String fromPhoneNumber) {
            this.fromPhoneNumber = fromPhoneNumber;
            return this;
        }

        public final String getToPhoneNumber() {
            return this.toPhoneNumber;
        }

        public final void setToPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
        }

        @Override
        public final Builder toPhoneNumber(String toPhoneNumber) {
            this.toPhoneNumber = toPhoneNumber;
            return this;
        }

        public final String getJoinToken() {
            return this.joinToken;
        }

        public final void setJoinToken(String joinToken) {
            this.joinToken = joinToken;
        }

        @Override
        public final Builder joinToken(String joinToken) {
            this.joinToken = joinToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingDialOutRequest build() {
            return new CreateMeetingDialOutRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMeetingDialOutRequest> {
        public Builder meetingId(String var1);

        public Builder fromPhoneNumber(String var1);

        public Builder toPhoneNumber(String var1);

        public Builder joinToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

