/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chime.model.ListSipMediaApplicationsResponse;

public class ListSipMediaApplicationsPublisher
implements SdkPublisher<ListSipMediaApplicationsResponse> {
    private final ChimeAsyncClient client;
    private final ListSipMediaApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSipMediaApplicationsPublisher(ChimeAsyncClient client, ListSipMediaApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSipMediaApplicationsPublisher(ChimeAsyncClient client, ListSipMediaApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSipMediaApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSipMediaApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSipMediaApplicationsResponseFetcher
    implements AsyncPageFetcher<ListSipMediaApplicationsResponse> {
        private ListSipMediaApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSipMediaApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSipMediaApplicationsResponse> nextPage(ListSipMediaApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSipMediaApplicationsPublisher.this.client.listSipMediaApplications(ListSipMediaApplicationsPublisher.this.firstRequest);
            }
            return ListSipMediaApplicationsPublisher.this.client.listSipMediaApplications((ListSipMediaApplicationsRequest)((Object)ListSipMediaApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

