/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedactRoomMessageRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, RedactRoomMessageRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RedactRoomMessageRequest.getter(RedactRoomMessageRequest::accountId)).setter(RedactRoomMessageRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoomId").getter(RedactRoomMessageRequest.getter(RedactRoomMessageRequest::roomId)).setter(RedactRoomMessageRequest.setter(Builder::roomId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(RedactRoomMessageRequest.getter(RedactRoomMessageRequest::messageId)).setter(RedactRoomMessageRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ROOM_ID_FIELD, MESSAGE_ID_FIELD));
    private final String accountId;
    private final String roomId;
    private final String messageId;

    private RedactRoomMessageRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.messageId = builder.messageId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String roomId() {
        return this.roomId;
    }

    public final String messageId() {
        return this.messageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactRoomMessageRequest)) {
            return false;
        }
        RedactRoomMessageRequest other = (RedactRoomMessageRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.roomId(), other.roomId()) && Objects.equals(this.messageId(), other.messageId());
    }

    public final String toString() {
        return ToString.builder((String)"RedactRoomMessageRequest").add("AccountId", (Object)this.accountId()).add("RoomId", (Object)this.roomId()).add("MessageId", (Object)this.messageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "RoomId": {
                return Optional.ofNullable(clazz.cast(this.roomId()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedactRoomMessageRequest, T> g) {
        return obj -> g.apply((RedactRoomMessageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String roomId;
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactRoomMessageRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.roomId(model.roomId);
            this.messageId(model.messageId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRoomId() {
            return this.roomId;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        @Override
        @Transient
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RedactRoomMessageRequest build() {
            return new RedactRoomMessageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RedactRoomMessageRequest> {
        public Builder accountId(String var1);

        public Builder roomId(String var1);

        public Builder messageId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

