/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.MediaPipelineSinkType;
import software.amazon.awssdk.services.chime.model.MediaPipelineSourceType;
import software.amazon.awssdk.services.chime.model.MediaPipelineStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaCapturePipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaCapturePipeline> {
    private static final SdkField<String> MEDIA_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaPipelineId").getter(MediaCapturePipeline.getter(MediaCapturePipeline::mediaPipelineId)).setter(MediaCapturePipeline.setter(Builder::mediaPipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPipelineId").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(MediaCapturePipeline.getter(MediaCapturePipeline::sourceTypeAsString)).setter(MediaCapturePipeline.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(MediaCapturePipeline.getter(MediaCapturePipeline::sourceArn)).setter(MediaCapturePipeline.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MediaCapturePipeline.getter(MediaCapturePipeline::statusAsString)).setter(MediaCapturePipeline.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkType").getter(MediaCapturePipeline.getter(MediaCapturePipeline::sinkTypeAsString)).setter(MediaCapturePipeline.setter(Builder::sinkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()}).build();
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SinkArn").getter(MediaCapturePipeline.getter(MediaCapturePipeline::sinkArn)).setter(MediaCapturePipeline.setter(Builder::sinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(MediaCapturePipeline.getter(MediaCapturePipeline::createdTimestamp)).setter(MediaCapturePipeline.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(MediaCapturePipeline.getter(MediaCapturePipeline::updatedTimestamp)).setter(MediaCapturePipeline.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_PIPELINE_ID_FIELD, SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, STATUS_FIELD, SINK_TYPE_FIELD, SINK_ARN_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mediaPipelineId;
    private final String sourceType;
    private final String sourceArn;
    private final String status;
    private final String sinkType;
    private final String sinkArn;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private MediaCapturePipeline(BuilderImpl builder) {
        this.mediaPipelineId = builder.mediaPipelineId;
        this.sourceType = builder.sourceType;
        this.sourceArn = builder.sourceArn;
        this.status = builder.status;
        this.sinkType = builder.sinkType;
        this.sinkArn = builder.sinkArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String mediaPipelineId() {
        return this.mediaPipelineId;
    }

    public final MediaPipelineSourceType sourceType() {
        return MediaPipelineSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final MediaPipelineStatus status() {
        return MediaPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MediaPipelineSinkType sinkType() {
        return MediaPipelineSinkType.fromValue(this.sinkType);
    }

    public final String sinkTypeAsString() {
        return this.sinkType;
    }

    public final String sinkArn() {
        return this.sinkArn;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaCapturePipeline)) {
            return false;
        }
        MediaCapturePipeline other = (MediaCapturePipeline)obj;
        return Objects.equals(this.mediaPipelineId(), other.mediaPipelineId()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sinkTypeAsString(), other.sinkTypeAsString()) && Objects.equals(this.sinkArn(), other.sinkArn()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MediaCapturePipeline").add("MediaPipelineId", (Object)this.mediaPipelineId()).add("SourceType", (Object)this.sourceTypeAsString()).add("SourceArn", (Object)(this.sourceArn() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("SinkType", (Object)this.sinkTypeAsString()).add("SinkArn", (Object)(this.sinkArn() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaPipelineId": {
                return Optional.ofNullable(clazz.cast(this.mediaPipelineId()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SinkType": {
                return Optional.ofNullable(clazz.cast(this.sinkTypeAsString()));
            }
            case "SinkArn": {
                return Optional.ofNullable(clazz.cast(this.sinkArn()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaCapturePipeline, T> g) {
        return obj -> g.apply((MediaCapturePipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaPipelineId;
        private String sourceType;
        private String sourceArn;
        private String status;
        private String sinkType;
        private String sinkArn;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaCapturePipeline model) {
            this.mediaPipelineId(model.mediaPipelineId);
            this.sourceType(model.sourceType);
            this.sourceArn(model.sourceArn);
            this.status(model.status);
            this.sinkType(model.sinkType);
            this.sinkArn(model.sinkArn);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getMediaPipelineId() {
            return this.mediaPipelineId;
        }

        @Override
        public final Builder mediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
            return this;
        }

        public final void setMediaPipelineId(String mediaPipelineId) {
            this.mediaPipelineId = mediaPipelineId;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(MediaPipelineSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MediaPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSinkType() {
            return this.sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        public final String getSinkArn() {
            return this.sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public MediaCapturePipeline build() {
            return new MediaCapturePipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaCapturePipeline> {
        public Builder mediaPipelineId(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(MediaPipelineSourceType var1);

        public Builder sourceArn(String var1);

        public Builder status(String var1);

        public Builder status(MediaPipelineStatus var1);

        public Builder sinkType(String var1);

        public Builder sinkType(MediaPipelineSinkType var1);

        public Builder sinkArn(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

