/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.Capability;
import software.amazon.awssdk.services.chime.model.CapabilityListCopier;
import software.amazon.awssdk.services.chime.model.GeoMatchLevel;
import software.amazon.awssdk.services.chime.model.GeoMatchParams;
import software.amazon.awssdk.services.chime.model.NumberSelectionBehavior;
import software.amazon.awssdk.services.chime.model.Participant;
import software.amazon.awssdk.services.chime.model.ParticipantsCopier;
import software.amazon.awssdk.services.chime.model.ProxySessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProxySession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProxySession> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(ProxySession.getter(ProxySession::voiceConnectorId)).setter(ProxySession.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorId").build()}).build();
    private static final SdkField<String> PROXY_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProxySessionId").getter(ProxySession.getter(ProxySession::proxySessionId)).setter(ProxySession.setter(Builder::proxySessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxySessionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProxySession.getter(ProxySession::name)).setter(ProxySession.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProxySession.getter(ProxySession::statusAsString)).setter(ProxySession.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> EXPIRY_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiryMinutes").getter(ProxySession.getter(ProxySession::expiryMinutes)).setter(ProxySession.setter(Builder::expiryMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryMinutes").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(ProxySession.getter(ProxySession::capabilitiesAsStrings)).setter(ProxySession.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ProxySession.getter(ProxySession::createdTimestamp)).setter(ProxySession.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(ProxySession.getter(ProxySession::updatedTimestamp)).setter(ProxySession.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedTimestamp").getter(ProxySession.getter(ProxySession::endedTimestamp)).setter(ProxySession.setter(Builder::endedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<Participant>> PARTICIPANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Participants").getter(ProxySession.getter(ProxySession::participants)).setter(ProxySession.setter(Builder::participants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Participants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Participant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NUMBER_SELECTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberSelectionBehavior").getter(ProxySession.getter(ProxySession::numberSelectionBehaviorAsString)).setter(ProxySession.setter(Builder::numberSelectionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberSelectionBehavior").build()}).build();
    private static final SdkField<String> GEO_MATCH_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeoMatchLevel").getter(ProxySession.getter(ProxySession::geoMatchLevelAsString)).setter(ProxySession.setter(Builder::geoMatchLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchLevel").build()}).build();
    private static final SdkField<GeoMatchParams> GEO_MATCH_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeoMatchParams").getter(ProxySession.getter(ProxySession::geoMatchParams)).setter(ProxySession.setter(Builder::geoMatchParams)).constructor(GeoMatchParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, PROXY_SESSION_ID_FIELD, NAME_FIELD, STATUS_FIELD, EXPIRY_MINUTES_FIELD, CAPABILITIES_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD, ENDED_TIMESTAMP_FIELD, PARTICIPANTS_FIELD, NUMBER_SELECTION_BEHAVIOR_FIELD, GEO_MATCH_LEVEL_FIELD, GEO_MATCH_PARAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String voiceConnectorId;
    private final String proxySessionId;
    private final String name;
    private final String status;
    private final Integer expiryMinutes;
    private final List<String> capabilities;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;
    private final Instant endedTimestamp;
    private final List<Participant> participants;
    private final String numberSelectionBehavior;
    private final String geoMatchLevel;
    private final GeoMatchParams geoMatchParams;

    private ProxySession(BuilderImpl builder) {
        this.voiceConnectorId = builder.voiceConnectorId;
        this.proxySessionId = builder.proxySessionId;
        this.name = builder.name;
        this.status = builder.status;
        this.expiryMinutes = builder.expiryMinutes;
        this.capabilities = builder.capabilities;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.endedTimestamp = builder.endedTimestamp;
        this.participants = builder.participants;
        this.numberSelectionBehavior = builder.numberSelectionBehavior;
        this.geoMatchLevel = builder.geoMatchLevel;
        this.geoMatchParams = builder.geoMatchParams;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final String proxySessionId() {
        return this.proxySessionId;
    }

    public final String name() {
        return this.name;
    }

    public final ProxySessionStatus status() {
        return ProxySessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer expiryMinutes() {
        return this.expiryMinutes;
    }

    public final List<Capability> capabilities() {
        return CapabilityListCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public final Instant endedTimestamp() {
        return this.endedTimestamp;
    }

    public final boolean hasParticipants() {
        return this.participants != null && !(this.participants instanceof SdkAutoConstructList);
    }

    public final List<Participant> participants() {
        return this.participants;
    }

    public final NumberSelectionBehavior numberSelectionBehavior() {
        return NumberSelectionBehavior.fromValue(this.numberSelectionBehavior);
    }

    public final String numberSelectionBehaviorAsString() {
        return this.numberSelectionBehavior;
    }

    public final GeoMatchLevel geoMatchLevel() {
        return GeoMatchLevel.fromValue(this.geoMatchLevel);
    }

    public final String geoMatchLevelAsString() {
        return this.geoMatchLevel;
    }

    public final GeoMatchParams geoMatchParams() {
        return this.geoMatchParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.proxySessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipants() ? this.participants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberSelectionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxySession)) {
            return false;
        }
        ProxySession other = (ProxySession)obj;
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.proxySessionId(), other.proxySessionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.expiryMinutes(), other.expiryMinutes()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp()) && Objects.equals(this.endedTimestamp(), other.endedTimestamp()) && this.hasParticipants() == other.hasParticipants() && Objects.equals(this.participants(), other.participants()) && Objects.equals(this.numberSelectionBehaviorAsString(), other.numberSelectionBehaviorAsString()) && Objects.equals(this.geoMatchLevelAsString(), other.geoMatchLevelAsString()) && Objects.equals(this.geoMatchParams(), other.geoMatchParams());
    }

    public final String toString() {
        return ToString.builder((String)"ProxySession").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("ProxySessionId", (Object)this.proxySessionId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("ExpiryMinutes", (Object)this.expiryMinutes()).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).add("EndedTimestamp", (Object)this.endedTimestamp()).add("Participants", this.hasParticipants() ? this.participants() : null).add("NumberSelectionBehavior", (Object)this.numberSelectionBehaviorAsString()).add("GeoMatchLevel", (Object)this.geoMatchLevelAsString()).add("GeoMatchParams", (Object)this.geoMatchParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "ProxySessionId": {
                return Optional.ofNullable(clazz.cast(this.proxySessionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ExpiryMinutes": {
                return Optional.ofNullable(clazz.cast(this.expiryMinutes()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
            case "EndedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endedTimestamp()));
            }
            case "Participants": {
                return Optional.ofNullable(clazz.cast(this.participants()));
            }
            case "NumberSelectionBehavior": {
                return Optional.ofNullable(clazz.cast(this.numberSelectionBehaviorAsString()));
            }
            case "GeoMatchLevel": {
                return Optional.ofNullable(clazz.cast(this.geoMatchLevelAsString()));
            }
            case "GeoMatchParams": {
                return Optional.ofNullable(clazz.cast(this.geoMatchParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProxySession, T> g) {
        return obj -> g.apply((ProxySession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private String proxySessionId;
        private String name;
        private String status;
        private Integer expiryMinutes;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;
        private Instant endedTimestamp;
        private List<Participant> participants = DefaultSdkAutoConstructList.getInstance();
        private String numberSelectionBehavior;
        private String geoMatchLevel;
        private GeoMatchParams geoMatchParams;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxySession model) {
            this.voiceConnectorId(model.voiceConnectorId);
            this.proxySessionId(model.proxySessionId);
            this.name(model.name);
            this.status(model.status);
            this.expiryMinutes(model.expiryMinutes);
            this.capabilitiesWithStrings(model.capabilities);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
            this.endedTimestamp(model.endedTimestamp);
            this.participants(model.participants);
            this.numberSelectionBehavior(model.numberSelectionBehavior);
            this.geoMatchLevel(model.geoMatchLevel);
            this.geoMatchParams(model.geoMatchParams);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final String getProxySessionId() {
            return this.proxySessionId;
        }

        @Override
        public final Builder proxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
            return this;
        }

        public final void setProxySessionId(String proxySessionId) {
            this.proxySessionId = proxySessionId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProxySessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getExpiryMinutes() {
            return this.expiryMinutes;
        }

        @Override
        public final Builder expiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
            return this;
        }

        public final void setExpiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilityListCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public final Instant getEndedTimestamp() {
            return this.endedTimestamp;
        }

        @Override
        public final Builder endedTimestamp(Instant endedTimestamp) {
            this.endedTimestamp = endedTimestamp;
            return this;
        }

        public final void setEndedTimestamp(Instant endedTimestamp) {
            this.endedTimestamp = endedTimestamp;
        }

        public final List<Participant.Builder> getParticipants() {
            List<Participant.Builder> result = ParticipantsCopier.copyToBuilder(this.participants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder participants(Collection<Participant> participants) {
            this.participants = ParticipantsCopier.copy(participants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participants(Participant ... participants) {
            this.participants(Arrays.asList(participants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participants(Consumer<Participant.Builder> ... participants) {
            this.participants(Stream.of(participants).map(c -> (Participant)((Participant.Builder)Participant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParticipants(Collection<Participant.BuilderImpl> participants) {
            this.participants = ParticipantsCopier.copyFromBuilder(participants);
        }

        public final String getNumberSelectionBehavior() {
            return this.numberSelectionBehavior;
        }

        @Override
        public final Builder numberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
            return this;
        }

        @Override
        public final Builder numberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior) {
            this.numberSelectionBehavior(numberSelectionBehavior == null ? null : numberSelectionBehavior.toString());
            return this;
        }

        public final void setNumberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
        }

        public final String getGeoMatchLevel() {
            return this.geoMatchLevel;
        }

        @Override
        public final Builder geoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
            return this;
        }

        @Override
        public final Builder geoMatchLevel(GeoMatchLevel geoMatchLevel) {
            this.geoMatchLevel(geoMatchLevel == null ? null : geoMatchLevel.toString());
            return this;
        }

        public final void setGeoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
        }

        public final GeoMatchParams.Builder getGeoMatchParams() {
            return this.geoMatchParams != null ? this.geoMatchParams.toBuilder() : null;
        }

        @Override
        public final Builder geoMatchParams(GeoMatchParams geoMatchParams) {
            this.geoMatchParams = geoMatchParams;
            return this;
        }

        public final void setGeoMatchParams(GeoMatchParams.BuilderImpl geoMatchParams) {
            this.geoMatchParams = geoMatchParams != null ? geoMatchParams.build() : null;
        }

        public ProxySession build() {
            return new ProxySession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProxySession> {
        public Builder voiceConnectorId(String var1);

        public Builder proxySessionId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ProxySessionStatus var1);

        public Builder expiryMinutes(Integer var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);

        public Builder endedTimestamp(Instant var1);

        public Builder participants(Collection<Participant> var1);

        public Builder participants(Participant ... var1);

        public Builder participants(Consumer<Participant.Builder> ... var1);

        public Builder numberSelectionBehavior(String var1);

        public Builder numberSelectionBehavior(NumberSelectionBehavior var1);

        public Builder geoMatchLevel(String var1);

        public Builder geoMatchLevel(GeoMatchLevel var1);

        public Builder geoMatchParams(GeoMatchParams var1);

        default public Builder geoMatchParams(Consumer<GeoMatchParams.Builder> geoMatchParams) {
            return this.geoMatchParams((GeoMatchParams)((GeoMatchParams.Builder)GeoMatchParams.builder().applyMutation(geoMatchParams)).build());
        }
    }
}

