/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.VoiceConnectorItem;
import software.amazon.awssdk.services.chime.model.VoiceConnectorItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VoiceConnectorGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VoiceConnectorGroup> {
    private static final SdkField<String> VOICE_CONNECTOR_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorGroupId").getter(VoiceConnectorGroup.getter(VoiceConnectorGroup::voiceConnectorGroupId)).setter(VoiceConnectorGroup.setter(Builder::voiceConnectorGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VoiceConnectorGroup.getter(VoiceConnectorGroup::name)).setter(VoiceConnectorGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<VoiceConnectorItem>> VOICE_CONNECTOR_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VoiceConnectorItems").getter(VoiceConnectorGroup.getter(VoiceConnectorGroup::voiceConnectorItems)).setter(VoiceConnectorGroup.setter(Builder::voiceConnectorItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VoiceConnectorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(VoiceConnectorGroup.getter(VoiceConnectorGroup::createdTimestamp)).setter(VoiceConnectorGroup.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(VoiceConnectorGroup.getter(VoiceConnectorGroup::updatedTimestamp)).setter(VoiceConnectorGroup.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_GROUP_ID_FIELD, NAME_FIELD, VOICE_CONNECTOR_ITEMS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String voiceConnectorGroupId;
    private final String name;
    private final List<VoiceConnectorItem> voiceConnectorItems;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private VoiceConnectorGroup(BuilderImpl builder) {
        this.voiceConnectorGroupId = builder.voiceConnectorGroupId;
        this.name = builder.name;
        this.voiceConnectorItems = builder.voiceConnectorItems;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String voiceConnectorGroupId() {
        return this.voiceConnectorGroupId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasVoiceConnectorItems() {
        return this.voiceConnectorItems != null && !(this.voiceConnectorItems instanceof SdkAutoConstructList);
    }

    public final List<VoiceConnectorItem> voiceConnectorItems() {
        return this.voiceConnectorItems;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorGroup)) {
            return false;
        }
        VoiceConnectorGroup other = (VoiceConnectorGroup)obj;
        return Objects.equals(this.voiceConnectorGroupId(), other.voiceConnectorGroupId()) && Objects.equals(this.name(), other.name()) && this.hasVoiceConnectorItems() == other.hasVoiceConnectorItems() && Objects.equals(this.voiceConnectorItems(), other.voiceConnectorItems()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"VoiceConnectorGroup").add("VoiceConnectorGroupId", (Object)this.voiceConnectorGroupId()).add("Name", (Object)this.name()).add("VoiceConnectorItems", this.hasVoiceConnectorItems() ? this.voiceConnectorItems() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorGroupId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorGroupId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VoiceConnectorItems": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorItems()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorGroup, T> g) {
        return obj -> g.apply((VoiceConnectorGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String voiceConnectorGroupId;
        private String name;
        private List<VoiceConnectorItem> voiceConnectorItems = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorGroup model) {
            this.voiceConnectorGroupId(model.voiceConnectorGroupId);
            this.name(model.name);
            this.voiceConnectorItems(model.voiceConnectorItems);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceConnectorGroupId() {
            return this.voiceConnectorGroupId;
        }

        @Override
        public final Builder voiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
            return this;
        }

        public final void setVoiceConnectorGroupId(String voiceConnectorGroupId) {
            this.voiceConnectorGroupId = voiceConnectorGroupId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<VoiceConnectorItem.Builder> getVoiceConnectorItems() {
            List<VoiceConnectorItem.Builder> result = VoiceConnectorItemListCopier.copyToBuilder(this.voiceConnectorItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder voiceConnectorItems(Collection<VoiceConnectorItem> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copy(voiceConnectorItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(VoiceConnectorItem ... voiceConnectorItems) {
            this.voiceConnectorItems(Arrays.asList(voiceConnectorItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... voiceConnectorItems) {
            this.voiceConnectorItems(Stream.of(voiceConnectorItems).map(c -> (VoiceConnectorItem)((VoiceConnectorItem.Builder)VoiceConnectorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVoiceConnectorItems(Collection<VoiceConnectorItem.BuilderImpl> voiceConnectorItems) {
            this.voiceConnectorItems = VoiceConnectorItemListCopier.copyFromBuilder(voiceConnectorItems);
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public VoiceConnectorGroup build() {
            return new VoiceConnectorGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VoiceConnectorGroup> {
        public Builder voiceConnectorGroupId(String var1);

        public Builder name(String var1);

        public Builder voiceConnectorItems(Collection<VoiceConnectorItem> var1);

        public Builder voiceConnectorItems(VoiceConnectorItem ... var1);

        public Builder voiceConnectorItems(Consumer<VoiceConnectorItem.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

