/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.AttendeeIdListCopier;
import software.amazon.awssdk.services.chime.model.ExternalUserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectedVideoStreams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectedVideoStreams> {
    private static final SdkField<List<String>> ATTENDEE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttendeeIds").getter(SelectedVideoStreams.getter(SelectedVideoStreams::attendeeIds)).setter(SelectedVideoStreams.setter(Builder::attendeeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttendeeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXTERNAL_USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExternalUserIds").getter(SelectedVideoStreams.getter(SelectedVideoStreams::externalUserIds)).setter(SelectedVideoStreams.setter(Builder::externalUserIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEE_IDS_FIELD, EXTERNAL_USER_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> attendeeIds;
    private final List<String> externalUserIds;

    private SelectedVideoStreams(BuilderImpl builder) {
        this.attendeeIds = builder.attendeeIds;
        this.externalUserIds = builder.externalUserIds;
    }

    public final boolean hasAttendeeIds() {
        return this.attendeeIds != null && !(this.attendeeIds instanceof SdkAutoConstructList);
    }

    public final List<String> attendeeIds() {
        return this.attendeeIds;
    }

    public final boolean hasExternalUserIds() {
        return this.externalUserIds != null && !(this.externalUserIds instanceof SdkAutoConstructList);
    }

    public final List<String> externalUserIds() {
        return this.externalUserIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttendeeIds() ? this.attendeeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalUserIds() ? this.externalUserIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectedVideoStreams)) {
            return false;
        }
        SelectedVideoStreams other = (SelectedVideoStreams)obj;
        return this.hasAttendeeIds() == other.hasAttendeeIds() && Objects.equals(this.attendeeIds(), other.attendeeIds()) && this.hasExternalUserIds() == other.hasExternalUserIds() && Objects.equals(this.externalUserIds(), other.externalUserIds());
    }

    public final String toString() {
        return ToString.builder((String)"SelectedVideoStreams").add("AttendeeIds", this.hasAttendeeIds() ? this.attendeeIds() : null).add("ExternalUserIds", (Object)(this.externalUserIds() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttendeeIds": {
                return Optional.ofNullable(clazz.cast(this.attendeeIds()));
            }
            case "ExternalUserIds": {
                return Optional.ofNullable(clazz.cast(this.externalUserIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectedVideoStreams, T> g) {
        return obj -> g.apply((SelectedVideoStreams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> attendeeIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> externalUserIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectedVideoStreams model) {
            this.attendeeIds(model.attendeeIds);
            this.externalUserIds(model.externalUserIds);
        }

        public final Collection<String> getAttendeeIds() {
            if (this.attendeeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attendeeIds;
        }

        public final void setAttendeeIds(Collection<String> attendeeIds) {
            this.attendeeIds = AttendeeIdListCopier.copy(attendeeIds);
        }

        @Override
        @Transient
        public final Builder attendeeIds(Collection<String> attendeeIds) {
            this.attendeeIds = AttendeeIdListCopier.copy(attendeeIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendeeIds(String ... attendeeIds) {
            this.attendeeIds(Arrays.asList(attendeeIds));
            return this;
        }

        public final Collection<String> getExternalUserIds() {
            if (this.externalUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.externalUserIds;
        }

        public final void setExternalUserIds(Collection<String> externalUserIds) {
            this.externalUserIds = ExternalUserIdListCopier.copy(externalUserIds);
        }

        @Override
        @Transient
        public final Builder externalUserIds(Collection<String> externalUserIds) {
            this.externalUserIds = ExternalUserIdListCopier.copy(externalUserIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder externalUserIds(String ... externalUserIds) {
            this.externalUserIds(Arrays.asList(externalUserIds));
            return this;
        }

        public SelectedVideoStreams build() {
            return new SelectedVideoStreams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectedVideoStreams> {
        public Builder attendeeIds(Collection<String> var1);

        public Builder attendeeIds(String ... var1);

        public Builder externalUserIds(Collection<String> var1);

        public Builder externalUserIds(String ... var1);
    }
}

