/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelephonySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelephonySettings> {
    private static final SdkField<Boolean> INBOUND_CALLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InboundCalling").getter(TelephonySettings.getter(TelephonySettings::inboundCalling)).setter(TelephonySettings.setter(Builder::inboundCalling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundCalling").build()}).build();
    private static final SdkField<Boolean> OUTBOUND_CALLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OutboundCalling").getter(TelephonySettings.getter(TelephonySettings::outboundCalling)).setter(TelephonySettings.setter(Builder::outboundCalling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCalling").build()}).build();
    private static final SdkField<Boolean> SMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SMS").getter(TelephonySettings.getter(TelephonySettings::sms)).setter(TelephonySettings.setter(Builder::sms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOUND_CALLING_FIELD, OUTBOUND_CALLING_FIELD, SMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean inboundCalling;
    private final Boolean outboundCalling;
    private final Boolean sms;

    private TelephonySettings(BuilderImpl builder) {
        this.inboundCalling = builder.inboundCalling;
        this.outboundCalling = builder.outboundCalling;
        this.sms = builder.sms;
    }

    public final Boolean inboundCalling() {
        return this.inboundCalling;
    }

    public final Boolean outboundCalling() {
        return this.outboundCalling;
    }

    public final Boolean sms() {
        return this.sms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundCalling());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundCalling());
        hashCode = 31 * hashCode + Objects.hashCode(this.sms());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelephonySettings)) {
            return false;
        }
        TelephonySettings other = (TelephonySettings)obj;
        return Objects.equals(this.inboundCalling(), other.inboundCalling()) && Objects.equals(this.outboundCalling(), other.outboundCalling()) && Objects.equals(this.sms(), other.sms());
    }

    public final String toString() {
        return ToString.builder((String)"TelephonySettings").add("InboundCalling", (Object)this.inboundCalling()).add("OutboundCalling", (Object)this.outboundCalling()).add("SMS", (Object)this.sms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InboundCalling": {
                return Optional.ofNullable(clazz.cast(this.inboundCalling()));
            }
            case "OutboundCalling": {
                return Optional.ofNullable(clazz.cast(this.outboundCalling()));
            }
            case "SMS": {
                return Optional.ofNullable(clazz.cast(this.sms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelephonySettings, T> g) {
        return obj -> g.apply((TelephonySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean inboundCalling;
        private Boolean outboundCalling;
        private Boolean sms;

        private BuilderImpl() {
        }

        private BuilderImpl(TelephonySettings model) {
            this.inboundCalling(model.inboundCalling);
            this.outboundCalling(model.outboundCalling);
            this.sms(model.sms);
        }

        public final Boolean getInboundCalling() {
            return this.inboundCalling;
        }

        public final void setInboundCalling(Boolean inboundCalling) {
            this.inboundCalling = inboundCalling;
        }

        @Override
        @Transient
        public final Builder inboundCalling(Boolean inboundCalling) {
            this.inboundCalling = inboundCalling;
            return this;
        }

        public final Boolean getOutboundCalling() {
            return this.outboundCalling;
        }

        public final void setOutboundCalling(Boolean outboundCalling) {
            this.outboundCalling = outboundCalling;
        }

        @Override
        @Transient
        public final Builder outboundCalling(Boolean outboundCalling) {
            this.outboundCalling = outboundCalling;
            return this;
        }

        public final Boolean getSms() {
            return this.sms;
        }

        public final void setSms(Boolean sms) {
            this.sms = sms;
        }

        @Override
        @Transient
        public final Builder sms(Boolean sms) {
            this.sms = sms;
            return this;
        }

        public TelephonySettings build() {
            return new TelephonySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelephonySettings> {
        public Builder inboundCalling(Boolean var1);

        public Builder outboundCalling(Boolean var1);

        public Builder sms(Boolean var1);
    }
}

