/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.EmailStatus;
import software.amazon.awssdk.services.chime.model.InviteStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Invite
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Invite> {
    private static final SdkField<String> INVITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InviteId").getter(Invite.getter(Invite::inviteId)).setter(Invite.setter(Builder::inviteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviteId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Invite.getter(Invite::statusAsString)).setter(Invite.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(Invite.getter(Invite::emailAddress)).setter(Invite.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> EMAIL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailStatus").getter(Invite.getter(Invite::emailStatusAsString)).setter(Invite.setter(Builder::emailStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITE_ID_FIELD, STATUS_FIELD, EMAIL_ADDRESS_FIELD, EMAIL_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inviteId;
    private final String status;
    private final String emailAddress;
    private final String emailStatus;

    private Invite(BuilderImpl builder) {
        this.inviteId = builder.inviteId;
        this.status = builder.status;
        this.emailAddress = builder.emailAddress;
        this.emailStatus = builder.emailStatus;
    }

    public final String inviteId() {
        return this.inviteId;
    }

    public final InviteStatus status() {
        return InviteStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final EmailStatus emailStatus() {
        return EmailStatus.fromValue(this.emailStatus);
    }

    public final String emailStatusAsString() {
        return this.emailStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inviteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invite)) {
            return false;
        }
        Invite other = (Invite)obj;
        return Objects.equals(this.inviteId(), other.inviteId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.emailStatusAsString(), other.emailStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Invite").add("InviteId", (Object)this.inviteId()).add("Status", (Object)this.statusAsString()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailStatus", (Object)this.emailStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InviteId": {
                return Optional.ofNullable(clazz.cast(this.inviteId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "EmailStatus": {
                return Optional.ofNullable(clazz.cast(this.emailStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invite, T> g) {
        return obj -> g.apply((Invite)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inviteId;
        private String status;
        private String emailAddress;
        private String emailStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Invite model) {
            this.inviteId(model.inviteId);
            this.status(model.status);
            this.emailAddress(model.emailAddress);
            this.emailStatus(model.emailStatus);
        }

        public final String getInviteId() {
            return this.inviteId;
        }

        public final void setInviteId(String inviteId) {
            this.inviteId = inviteId;
        }

        @Override
        @Transient
        public final Builder inviteId(String inviteId) {
            this.inviteId = inviteId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InviteStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getEmailStatus() {
            return this.emailStatus;
        }

        public final void setEmailStatus(String emailStatus) {
            this.emailStatus = emailStatus;
        }

        @Override
        @Transient
        public final Builder emailStatus(String emailStatus) {
            this.emailStatus = emailStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder emailStatus(EmailStatus emailStatus) {
            this.emailStatus(emailStatus == null ? null : emailStatus.toString());
            return this;
        }

        public Invite build() {
            return new Invite(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Invite> {
        public Builder inviteId(String var1);

        public Builder status(String var1);

        public Builder status(InviteStatus var1);

        public Builder emailAddress(String var1);

        public Builder emailStatus(String var1);

        public Builder emailStatus(EmailStatus var1);
    }
}

