/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.OrderedPhoneNumber;
import software.amazon.awssdk.services.chime.model.OrderedPhoneNumberListCopier;
import software.amazon.awssdk.services.chime.model.PhoneNumberOrderStatus;
import software.amazon.awssdk.services.chime.model.PhoneNumberProductType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumberOrder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumberOrder> {
    private static final SdkField<String> PHONE_NUMBER_ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberOrderId").getter(PhoneNumberOrder.getter(PhoneNumberOrder::phoneNumberOrderId)).setter(PhoneNumberOrder.setter(Builder::phoneNumberOrderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrderId").build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductType").getter(PhoneNumberOrder.getter(PhoneNumberOrder::productTypeAsString)).setter(PhoneNumberOrder.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PhoneNumberOrder.getter(PhoneNumberOrder::statusAsString)).setter(PhoneNumberOrder.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<OrderedPhoneNumber>> ORDERED_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderedPhoneNumbers").getter(PhoneNumberOrder.getter(PhoneNumberOrder::orderedPhoneNumbers)).setter(PhoneNumberOrder.setter(Builder::orderedPhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedPhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderedPhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(PhoneNumberOrder.getter(PhoneNumberOrder::createdTimestamp)).setter(PhoneNumberOrder.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(PhoneNumberOrder.getter(PhoneNumberOrder::updatedTimestamp)).setter(PhoneNumberOrder.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDER_ID_FIELD, PRODUCT_TYPE_FIELD, STATUS_FIELD, ORDERED_PHONE_NUMBERS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phoneNumberOrderId;
    private final String productType;
    private final String status;
    private final List<OrderedPhoneNumber> orderedPhoneNumbers;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private PhoneNumberOrder(BuilderImpl builder) {
        this.phoneNumberOrderId = builder.phoneNumberOrderId;
        this.productType = builder.productType;
        this.status = builder.status;
        this.orderedPhoneNumbers = builder.orderedPhoneNumbers;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String phoneNumberOrderId() {
        return this.phoneNumberOrderId;
    }

    public final PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final PhoneNumberOrderStatus status() {
        return PhoneNumberOrderStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasOrderedPhoneNumbers() {
        return this.orderedPhoneNumbers != null && !(this.orderedPhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<OrderedPhoneNumber> orderedPhoneNumbers() {
        return this.orderedPhoneNumbers;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberOrderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderedPhoneNumbers() ? this.orderedPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberOrder)) {
            return false;
        }
        PhoneNumberOrder other = (PhoneNumberOrder)obj;
        return Objects.equals(this.phoneNumberOrderId(), other.phoneNumberOrderId()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasOrderedPhoneNumbers() == other.hasOrderedPhoneNumbers() && Objects.equals(this.orderedPhoneNumbers(), other.orderedPhoneNumbers()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"PhoneNumberOrder").add("PhoneNumberOrderId", (Object)this.phoneNumberOrderId()).add("ProductType", (Object)this.productTypeAsString()).add("Status", (Object)this.statusAsString()).add("OrderedPhoneNumbers", this.hasOrderedPhoneNumbers() ? this.orderedPhoneNumbers() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberOrderId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberOrderId()));
            }
            case "ProductType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OrderedPhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.orderedPhoneNumbers()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberOrder, T> g) {
        return obj -> g.apply((PhoneNumberOrder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumberOrderId;
        private String productType;
        private String status;
        private List<OrderedPhoneNumber> orderedPhoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberOrder model) {
            this.phoneNumberOrderId(model.phoneNumberOrderId);
            this.productType(model.productType);
            this.status(model.status);
            this.orderedPhoneNumbers(model.orderedPhoneNumbers);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getPhoneNumberOrderId() {
            return this.phoneNumberOrderId;
        }

        @Override
        public final Builder phoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
            return this;
        }

        public final void setPhoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
        }

        public final String getProductType() {
            return this.productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberOrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final List<OrderedPhoneNumber.Builder> getOrderedPhoneNumbers() {
            List<OrderedPhoneNumber.Builder> result = OrderedPhoneNumberListCopier.copyToBuilder(this.orderedPhoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copy(orderedPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(OrderedPhoneNumber ... orderedPhoneNumbers) {
            this.orderedPhoneNumbers(Arrays.asList(orderedPhoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder> ... orderedPhoneNumbers) {
            this.orderedPhoneNumbers(Stream.of(orderedPhoneNumbers).map(c -> (OrderedPhoneNumber)((OrderedPhoneNumber.Builder)OrderedPhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderedPhoneNumbers(Collection<OrderedPhoneNumber.BuilderImpl> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copyFromBuilder(orderedPhoneNumbers);
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        public PhoneNumberOrder build() {
            return new PhoneNumberOrder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumberOrder> {
        public Builder phoneNumberOrderId(String var1);

        public Builder productType(String var1);

        public Builder productType(PhoneNumberProductType var1);

        public Builder status(String var1);

        public Builder status(PhoneNumberOrderStatus var1);

        public Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> var1);

        public Builder orderedPhoneNumbers(OrderedPhoneNumber ... var1);

        public Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

