/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.E164PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAvailablePhoneNumbersResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("E164PhoneNumbers").getter(SearchAvailablePhoneNumbersResponse.getter(SearchAvailablePhoneNumbersResponse::e164PhoneNumbers)).setter(SearchAvailablePhoneNumbersResponse.setter(Builder::e164PhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAvailablePhoneNumbersResponse.getter(SearchAvailablePhoneNumbersResponse::nextToken)).setter(SearchAvailablePhoneNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> e164PhoneNumbers;
    private final String nextToken;

    private SearchAvailablePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasE164PhoneNumbers() {
        return this.e164PhoneNumbers != null && !(this.e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<String> e164PhoneNumbers() {
        return this.e164PhoneNumbers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasE164PhoneNumbers() ? this.e164PhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersResponse)) {
            return false;
        }
        SearchAvailablePhoneNumbersResponse other = (SearchAvailablePhoneNumbersResponse)((Object)obj);
        return this.hasE164PhoneNumbers() == other.hasE164PhoneNumbers() && Objects.equals(this.e164PhoneNumbers(), other.e164PhoneNumbers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAvailablePhoneNumbersResponse").add("E164PhoneNumbers", (Object)(this.e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "E164PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumbers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersResponse, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersResponse model) {
            super(model);
            this.e164PhoneNumbers(model.e164PhoneNumbers);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (this.e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.e164PhoneNumbers;
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String ... e164PhoneNumbers) {
            this.e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchAvailablePhoneNumbersResponse build() {
            return new SearchAvailablePhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
        public Builder e164PhoneNumbers(Collection<String> var1);

        public Builder e164PhoneNumbers(String ... var1);

        public Builder nextToken(String var1);
    }
}

