/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.MemberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberId").getter(Member.getter(Member::memberId)).setter(Member.setter(Builder::memberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()}).build();
    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberType").getter(Member.getter(Member::memberTypeAsString)).setter(Member.setter(Builder::memberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(Member.getter(Member::email)).setter(Member.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> FULL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FullName").getter(Member.getter(Member::fullName)).setter(Member.setter(Builder::fullName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Member.getter(Member::accountId)).setter(Member.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ID_FIELD, MEMBER_TYPE_FIELD, EMAIL_FIELD, FULL_NAME_FIELD, ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String memberId;
    private final String memberType;
    private final String email;
    private final String fullName;
    private final String accountId;

    private Member(BuilderImpl builder) {
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.accountId = builder.accountId;
    }

    public final String memberId() {
        return this.memberId;
    }

    public final MemberType memberType() {
        return MemberType.fromValue(this.memberType);
    }

    public final String memberTypeAsString() {
        return this.memberType;
    }

    public final String email() {
        return this.email;
    }

    public final String fullName() {
        return this.fullName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.memberId(), other.memberId()) && Objects.equals(this.memberTypeAsString(), other.memberTypeAsString()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.fullName(), other.fullName()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("MemberId", (Object)this.memberId()).add("MemberType", (Object)this.memberTypeAsString()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("FullName", (Object)(this.fullName() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberId": {
                return Optional.ofNullable(clazz.cast(this.memberId()));
            }
            case "MemberType": {
                return Optional.ofNullable(clazz.cast(this.memberTypeAsString()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "FullName": {
                return Optional.ofNullable(clazz.cast(this.fullName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String memberId;
        private String memberType;
        private String email;
        private String fullName;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.memberId(model.memberId);
            this.memberType(model.memberType);
            this.email(model.email);
            this.fullName(model.fullName);
            this.accountId(model.accountId);
        }

        public final String getMemberId() {
            return this.memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final String getMemberType() {
            return this.memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public final void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder memberId(String var1);

        public Builder memberType(String var1);

        public Builder memberType(MemberType var1);

        public Builder email(String var1);

        public Builder fullName(String var1);

        public Builder accountId(String var1);
    }
}

