/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeetingNotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeetingNotificationConfiguration> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(MeetingNotificationConfiguration.getter(MeetingNotificationConfiguration::snsTopicArn)).setter(MeetingNotificationConfiguration.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SQS_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqsQueueArn").getter(MeetingNotificationConfiguration.getter(MeetingNotificationConfiguration::sqsQueueArn)).setter(MeetingNotificationConfiguration.setter(Builder::sqsQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD, SQS_QUEUE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snsTopicArn;
    private final String sqsQueueArn;

    private MeetingNotificationConfiguration(BuilderImpl builder) {
        this.snsTopicArn = builder.snsTopicArn;
        this.sqsQueueArn = builder.sqsQueueArn;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String sqsQueueArn() {
        return this.sqsQueueArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingNotificationConfiguration)) {
            return false;
        }
        MeetingNotificationConfiguration other = (MeetingNotificationConfiguration)obj;
        return Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.sqsQueueArn(), other.sqsQueueArn());
    }

    public final String toString() {
        return ToString.builder((String)"MeetingNotificationConfiguration").add("SnsTopicArn", (Object)(this.snsTopicArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SqsQueueArn", (Object)(this.sqsQueueArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SqsQueueArn": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeetingNotificationConfiguration, T> g) {
        return obj -> g.apply((MeetingNotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopicArn;
        private String sqsQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingNotificationConfiguration model) {
            this.snsTopicArn(model.snsTopicArn);
            this.sqsQueueArn(model.sqsQueueArn);
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSqsQueueArn() {
            return this.sqsQueueArn;
        }

        @Override
        public final Builder sqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
            return this;
        }

        public final void setSqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
        }

        public MeetingNotificationConfiguration build() {
            return new MeetingNotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeetingNotificationConfiguration> {
        public Builder snsTopicArn(String var1);

        public Builder sqsQueueArn(String var1);
    }
}

