/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChannelMembershipType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppInstanceUserMembershipSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppInstanceUserMembershipSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AppInstanceUserMembershipSummary.getter(AppInstanceUserMembershipSummary::typeAsString)).setter(AppInstanceUserMembershipSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> READ_MARKER_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReadMarkerTimestamp").getter(AppInstanceUserMembershipSummary.getter(AppInstanceUserMembershipSummary::readMarkerTimestamp)).setter(AppInstanceUserMembershipSummary.setter(Builder::readMarkerTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadMarkerTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, READ_MARKER_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Instant readMarkerTimestamp;

    private AppInstanceUserMembershipSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.readMarkerTimestamp = builder.readMarkerTimestamp;
    }

    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant readMarkerTimestamp() {
        return this.readMarkerTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.readMarkerTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceUserMembershipSummary)) {
            return false;
        }
        AppInstanceUserMembershipSummary other = (AppInstanceUserMembershipSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.readMarkerTimestamp(), other.readMarkerTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"AppInstanceUserMembershipSummary").add("Type", (Object)this.typeAsString()).add("ReadMarkerTimestamp", (Object)this.readMarkerTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ReadMarkerTimestamp": {
                return Optional.ofNullable(clazz.cast(this.readMarkerTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceUserMembershipSummary, T> g) {
        return obj -> g.apply((AppInstanceUserMembershipSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Instant readMarkerTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceUserMembershipSummary model) {
            this.type(model.type);
            this.readMarkerTimestamp(model.readMarkerTimestamp);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getReadMarkerTimestamp() {
            return this.readMarkerTimestamp;
        }

        @Override
        public final Builder readMarkerTimestamp(Instant readMarkerTimestamp) {
            this.readMarkerTimestamp = readMarkerTimestamp;
            return this;
        }

        public final void setReadMarkerTimestamp(Instant readMarkerTimestamp) {
            this.readMarkerTimestamp = readMarkerTimestamp;
        }

        public AppInstanceUserMembershipSummary build() {
            return new AppInstanceUserMembershipSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppInstanceUserMembershipSummary> {
        public Builder type(String var1);

        public Builder type(ChannelMembershipType var1);

        public Builder readMarkerTimestamp(Instant var1);
    }
}

