/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user ID and user fields to update, used with the <a>BatchUpdateUser</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequestItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateUserRequestItem.Builder, UpdateUserRequestItem> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UpdateUserRequestItem::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseType").getter(getter(UpdateUserRequestItem::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()).build();

    private static final SdkField<String> USER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserType").getter(getter(UpdateUserRequestItem::userTypeAsString)).setter(setter(Builder::userType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserType").build()).build();

    private static final SdkField<AlexaForBusinessMetadata> ALEXA_FOR_BUSINESS_METADATA_FIELD = SdkField
            .<AlexaForBusinessMetadata> builder(MarshallingType.SDK_POJO).memberName("AlexaForBusinessMetadata")
            .getter(getter(UpdateUserRequestItem::alexaForBusinessMetadata)).setter(setter(Builder::alexaForBusinessMetadata))
            .constructor(AlexaForBusinessMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            LICENSE_TYPE_FIELD, USER_TYPE_FIELD, ALEXA_FOR_BUSINESS_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String licenseType;

    private final String userType;

    private final AlexaForBusinessMetadata alexaForBusinessMetadata;

    private UpdateUserRequestItem(BuilderImpl builder) {
        this.userId = builder.userId;
        this.licenseType = builder.licenseType;
        this.userType = builder.userType;
        this.alexaForBusinessMetadata = builder.alexaForBusinessMetadata;
    }

    /**
     * <p>
     * The user ID.
     * </p>
     * 
     * @return The user ID.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The user license type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The user license type.
     * @see License
     */
    public final License licenseType() {
        return License.fromValue(licenseType);
    }

    /**
     * <p>
     * The user license type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link License#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The user license type.
     * @see License
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The user type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return The user type.
     * @see UserType
     */
    public final UserType userType() {
        return UserType.fromValue(userType);
    }

    /**
     * <p>
     * The user type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userType} will
     * return {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userTypeAsString}.
     * </p>
     * 
     * @return The user type.
     * @see UserType
     */
    public final String userTypeAsString() {
        return userType;
    }

    /**
     * <p>
     * The Alexa for Business metadata.
     * </p>
     * 
     * @return The Alexa for Business metadata.
     */
    public final AlexaForBusinessMetadata alexaForBusinessMetadata() {
        return alexaForBusinessMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alexaForBusinessMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequestItem)) {
            return false;
        }
        UpdateUserRequestItem other = (UpdateUserRequestItem) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(userTypeAsString(), other.userTypeAsString())
                && Objects.equals(alexaForBusinessMetadata(), other.alexaForBusinessMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequestItem").add("UserId", userId()).add("LicenseType", licenseTypeAsString())
                .add("UserType", userTypeAsString()).add("AlexaForBusinessMetadata", alexaForBusinessMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "UserType":
            return Optional.ofNullable(clazz.cast(userTypeAsString()));
        case "AlexaForBusinessMetadata":
            return Optional.ofNullable(clazz.cast(alexaForBusinessMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequestItem, T> g) {
        return obj -> g.apply((UpdateUserRequestItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateUserRequestItem> {
        /**
         * <p>
         * The user ID.
         * </p>
         * 
         * @param userId
         *        The user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The user license type.
         * </p>
         * 
         * @param licenseType
         *        The user license type.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The user license type.
         * </p>
         * 
         * @param licenseType
         *        The user license type.
         * @see License
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see License
         */
        Builder licenseType(License licenseType);

        /**
         * <p>
         * The user type.
         * </p>
         * 
         * @param userType
         *        The user type.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(String userType);

        /**
         * <p>
         * The user type.
         * </p>
         * 
         * @param userType
         *        The user type.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder userType(UserType userType);

        /**
         * <p>
         * The Alexa for Business metadata.
         * </p>
         * 
         * @param alexaForBusinessMetadata
         *        The Alexa for Business metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata);

        /**
         * <p>
         * The Alexa for Business metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link AlexaForBusinessMetadata.Builder} avoiding the
         * need to create one manually via {@link AlexaForBusinessMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlexaForBusinessMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #alexaForBusinessMetadata(AlexaForBusinessMetadata)}.
         * 
         * @param alexaForBusinessMetadata
         *        a consumer that will call methods on {@link AlexaForBusinessMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alexaForBusinessMetadata(AlexaForBusinessMetadata)
         */
        default Builder alexaForBusinessMetadata(Consumer<AlexaForBusinessMetadata.Builder> alexaForBusinessMetadata) {
            return alexaForBusinessMetadata(AlexaForBusinessMetadata.builder().applyMutation(alexaForBusinessMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String licenseType;

        private String userType;

        private AlexaForBusinessMetadata alexaForBusinessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequestItem model) {
            userId(model.userId);
            licenseType(model.licenseType);
            userType(model.userType);
            alexaForBusinessMetadata(model.alexaForBusinessMetadata);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getUserType() {
            return userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        public final AlexaForBusinessMetadata.Builder getAlexaForBusinessMetadata() {
            return alexaForBusinessMetadata != null ? alexaForBusinessMetadata.toBuilder() : null;
        }

        @Override
        public final Builder alexaForBusinessMetadata(AlexaForBusinessMetadata alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata;
            return this;
        }

        public final void setAlexaForBusinessMetadata(AlexaForBusinessMetadata.BuilderImpl alexaForBusinessMetadata) {
            this.alexaForBusinessMetadata = alexaForBusinessMetadata != null ? alexaForBusinessMetadata.build() : null;
        }

        @Override
        public UpdateUserRequestItem build() {
            return new UpdateUserRequestItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
