/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Logging configuration of the SIP media application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SipMediaApplicationLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SipMediaApplicationLoggingConfiguration.Builder, SipMediaApplicationLoggingConfiguration> {
    private static final SdkField<Boolean> ENABLE_SIP_MEDIA_APPLICATION_MESSAGE_LOGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSipMediaApplicationMessageLogs")
            .getter(getter(SipMediaApplicationLoggingConfiguration::enableSipMediaApplicationMessageLogs))
            .setter(setter(Builder::enableSipMediaApplicationMessageLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableSipMediaApplicationMessageLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENABLE_SIP_MEDIA_APPLICATION_MESSAGE_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableSipMediaApplicationMessageLogs;

    private SipMediaApplicationLoggingConfiguration(BuilderImpl builder) {
        this.enableSipMediaApplicationMessageLogs = builder.enableSipMediaApplicationMessageLogs;
    }

    /**
     * <p>
     * Enables application message logs for the SIP media application.
     * </p>
     * 
     * @return Enables application message logs for the SIP media application.
     */
    public final Boolean enableSipMediaApplicationMessageLogs() {
        return enableSipMediaApplicationMessageLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableSipMediaApplicationMessageLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplicationLoggingConfiguration)) {
            return false;
        }
        SipMediaApplicationLoggingConfiguration other = (SipMediaApplicationLoggingConfiguration) obj;
        return Objects.equals(enableSipMediaApplicationMessageLogs(), other.enableSipMediaApplicationMessageLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SipMediaApplicationLoggingConfiguration")
                .add("EnableSipMediaApplicationMessageLogs", enableSipMediaApplicationMessageLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableSipMediaApplicationMessageLogs":
            return Optional.ofNullable(clazz.cast(enableSipMediaApplicationMessageLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplicationLoggingConfiguration, T> g) {
        return obj -> g.apply((SipMediaApplicationLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SipMediaApplicationLoggingConfiguration> {
        /**
         * <p>
         * Enables application message logs for the SIP media application.
         * </p>
         * 
         * @param enableSipMediaApplicationMessageLogs
         *        Enables application message logs for the SIP media application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSipMediaApplicationMessageLogs(Boolean enableSipMediaApplicationMessageLogs);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableSipMediaApplicationMessageLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplicationLoggingConfiguration model) {
            enableSipMediaApplicationMessageLogs(model.enableSipMediaApplicationMessageLogs);
        }

        public final Boolean getEnableSipMediaApplicationMessageLogs() {
            return enableSipMediaApplicationMessageLogs;
        }

        @Override
        public final Builder enableSipMediaApplicationMessageLogs(Boolean enableSipMediaApplicationMessageLogs) {
            this.enableSipMediaApplicationMessageLogs = enableSipMediaApplicationMessageLogs;
            return this;
        }

        public final void setEnableSipMediaApplicationMessageLogs(Boolean enableSipMediaApplicationMessageLogs) {
            this.enableSipMediaApplicationMessageLogs = enableSipMediaApplicationMessageLogs;
        }

        @Override
        public SipMediaApplicationLoggingConfiguration build() {
            return new SipMediaApplicationLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
